/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.sink;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.net.URI;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.DriverBuilder;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSinkQueryInfo;
import org.apache.seatunnel.connectors.seatunnel.neo4j.exception.Neo4jConnectorException;
import org.apache.seatunnel.connectors.seatunnel.neo4j.sink.Neo4jSinkWriter;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.neo4j.driver.AuthTokens;

@AutoService(value={SeaTunnelSink.class})
public class Neo4jSink
implements SeaTunnelSink<SeaTunnelRow, Void, Void, Void> {
    private SeaTunnelRowType rowType;
    private final Neo4jSinkQueryInfo neo4JSinkQueryInfo = new Neo4jSinkQueryInfo();

    public String getPluginName() {
        return "Neo4j";
    }

    public void prepare(Config config) throws PrepareFailException {
        this.neo4JSinkQueryInfo.setDriverBuilder(this.prepareDriver(config));
        CheckResult queryConfigCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jSinkConfig.KEY_QUERY.key(), Neo4jSinkConfig.QUERY_PARAM_POSITION.key()});
        if (!queryConfigCheck.isSuccess()) {
            throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SINK, queryConfigCheck.getMsg()));
        }
        this.neo4JSinkQueryInfo.setQuery(config.getString(Neo4jSinkConfig.KEY_QUERY.key()));
        this.neo4JSinkQueryInfo.setQueryParamPosition(config.getObject(Neo4jSinkConfig.QUERY_PARAM_POSITION.key()).unwrapped());
    }

    private DriverBuilder prepareDriver(Config config) {
        CheckResult uriConfigCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jSinkConfig.KEY_NEO4J_URI.key(), Neo4jSinkConfig.KEY_DATABASE.key()});
        CheckResult authConfigCheck = CheckConfigUtil.checkAtLeastOneExists((Config)config, (String[])new String[]{Neo4jSinkConfig.KEY_USERNAME.key(), Neo4jSinkConfig.KEY_BEARER_TOKEN.key(), Neo4jSinkConfig.KEY_KERBEROS_TICKET.key()});
        CheckResult mergedConfigCheck = CheckConfigUtil.mergeCheckResults((CheckResult[])new CheckResult[]{uriConfigCheck, authConfigCheck});
        if (!mergedConfigCheck.isSuccess()) {
            throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SINK, mergedConfigCheck.getMsg()));
        }
        URI uri = URI.create(config.getString(Neo4jSinkConfig.KEY_NEO4J_URI.key()));
        DriverBuilder driverBuilder = DriverBuilder.create(uri);
        if (config.hasPath(Neo4jSinkConfig.KEY_USERNAME.key())) {
            CheckResult pwParamCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jSinkConfig.KEY_PASSWORD.key()});
            if (!pwParamCheck.isSuccess()) {
                throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SINK, pwParamCheck.getMsg()));
            }
            String username = config.getString(Neo4jSinkConfig.KEY_USERNAME.key());
            String password = config.getString(Neo4jSinkConfig.KEY_PASSWORD.key());
            driverBuilder.setUsername(username);
            driverBuilder.setPassword(password);
        } else if (config.hasPath(Neo4jSinkConfig.KEY_BEARER_TOKEN.key())) {
            String bearerToken = config.getString(Neo4jSinkConfig.KEY_BEARER_TOKEN.key());
            AuthTokens.bearer(bearerToken);
            driverBuilder.setBearerToken(bearerToken);
        } else {
            String kerberosTicket = config.getString(Neo4jSinkConfig.KEY_KERBEROS_TICKET.key());
            AuthTokens.kerberos(kerberosTicket);
            driverBuilder.setBearerToken(kerberosTicket);
        }
        driverBuilder.setDatabase(config.getString(Neo4jSinkConfig.KEY_DATABASE.key()));
        if (config.hasPath(Neo4jSinkConfig.KEY_MAX_CONNECTION_TIMEOUT.key())) {
            driverBuilder.setMaxConnectionTimeoutSeconds(config.getLong(Neo4jSinkConfig.KEY_MAX_CONNECTION_TIMEOUT.key()));
        }
        if (config.hasPath(Neo4jSinkConfig.KEY_MAX_TRANSACTION_RETRY_TIME.key())) {
            driverBuilder.setMaxTransactionRetryTimeSeconds(config.getLong(Neo4jSinkConfig.KEY_MAX_TRANSACTION_RETRY_TIME.key()));
        }
        return driverBuilder;
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.rowType = seaTunnelRowType;
    }

    public SeaTunnelDataType<SeaTunnelRow> getConsumedType() {
        return this.rowType;
    }

    public SinkWriter<SeaTunnelRow, Void, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new Neo4jSinkWriter(this.neo4JSinkQueryInfo);
    }
}

