/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.neo4j.source;

import com.google.auto.service.AutoService;
import java.net.URI;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.DriverBuilder;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.neo4j.config.Neo4jSourceQueryInfo;
import org.apache.seatunnel.connectors.seatunnel.neo4j.exception.Neo4jConnectorException;
import org.apache.seatunnel.connectors.seatunnel.neo4j.source.Neo4jSourceReader;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.neo4j.driver.AuthTokens;

@AutoService(value={SeaTunnelSource.class})
public class Neo4jSource
extends AbstractSingleSplitSource<SeaTunnelRow>
implements SupportColumnProjection {
    private final Neo4jSourceQueryInfo neo4jSourceQueryInfo = new Neo4jSourceQueryInfo();
    private SeaTunnelRowType rowType;

    public String getPluginName() {
        return "Neo4j";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        this.neo4jSourceQueryInfo.setDriverBuilder(this.prepareDriver(pluginConfig));
        CheckResult configCheck = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{Neo4jSourceConfig.KEY_QUERY.key(), CatalogTableUtil.SCHEMA.key()});
        if (!configCheck.isSuccess()) {
            throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SOURCE, configCheck.getMsg()));
        }
        this.neo4jSourceQueryInfo.setQuery(pluginConfig.getString(Neo4jSourceConfig.KEY_QUERY.key()));
        this.rowType = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.rowType;
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new Neo4jSourceReader(readerContext, this.neo4jSourceQueryInfo, this.rowType);
    }

    private DriverBuilder prepareDriver(Config config) {
        CheckResult uriConfigCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jSourceConfig.KEY_NEO4J_URI.key(), Neo4jSourceConfig.KEY_DATABASE.key()});
        CheckResult authConfigCheck = CheckConfigUtil.checkAtLeastOneExists((Config)config, (String[])new String[]{Neo4jSourceConfig.KEY_USERNAME.key(), Neo4jSourceConfig.KEY_BEARER_TOKEN.key(), Neo4jSourceConfig.KEY_KERBEROS_TICKET.key()});
        CheckResult mergedConfigCheck = CheckConfigUtil.mergeCheckResults((CheckResult[])new CheckResult[]{uriConfigCheck, authConfigCheck});
        if (!mergedConfigCheck.isSuccess()) {
            throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SOURCE, mergedConfigCheck.getMsg()));
        }
        URI uri = URI.create(config.getString(Neo4jSourceConfig.KEY_NEO4J_URI.key()));
        DriverBuilder driverBuilder = DriverBuilder.create(uri);
        if (config.hasPath(Neo4jSourceConfig.KEY_USERNAME.key())) {
            CheckResult pwParamCheck = CheckConfigUtil.checkAllExists((Config)config, (String[])new String[]{Neo4jSourceConfig.KEY_PASSWORD.key()});
            if (!pwParamCheck.isSuccess()) {
                throw new Neo4jConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", "Neo4j", PluginType.SOURCE, pwParamCheck.getMsg()));
            }
            String username = config.getString(Neo4jSourceConfig.KEY_USERNAME.key());
            String password = config.getString(Neo4jSourceConfig.KEY_PASSWORD.key());
            driverBuilder.setUsername(username);
            driverBuilder.setPassword(password);
        } else if (config.hasPath(Neo4jSourceConfig.KEY_BEARER_TOKEN.key())) {
            String bearerToken = config.getString(Neo4jSourceConfig.KEY_BEARER_TOKEN.key());
            AuthTokens.bearer(bearerToken);
            driverBuilder.setBearerToken(bearerToken);
        } else {
            String kerberosTicket = config.getString(Neo4jSourceConfig.KEY_KERBEROS_TICKET.key());
            AuthTokens.kerberos(kerberosTicket);
            driverBuilder.setBearerToken(kerberosTicket);
        }
        driverBuilder.setDatabase(config.getString(Neo4jSourceConfig.KEY_DATABASE.key()));
        if (config.hasPath(Neo4jSourceConfig.KEY_MAX_CONNECTION_TIMEOUT.key())) {
            driverBuilder.setMaxConnectionTimeoutSeconds(config.getLong(Neo4jSourceConfig.KEY_MAX_CONNECTION_TIMEOUT.key()));
        }
        if (config.hasPath(Neo4jSourceConfig.KEY_MAX_TRANSACTION_RETRY_TIME.key())) {
            driverBuilder.setMaxTransactionRetryTimeSeconds(config.getLong(Neo4jSourceConfig.KEY_MAX_TRANSACTION_RETRY_TIME.key()));
        }
        return driverBuilder;
    }
}

