/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.split;

import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.javax.annotation.Nullable;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.stop.StopCursor;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.topic.TopicPartition;

public class PulsarPartitionSplit
implements SourceSplit {
    private final TopicPartition partition;
    private final StopCursor stopCursor;
    @Nullable
    private MessageId latestConsumedId;

    public PulsarPartitionSplit(TopicPartition partition, StopCursor stopCursor) {
        this(partition, stopCursor, null);
    }

    public PulsarPartitionSplit(TopicPartition partition, StopCursor stopCursor, MessageId latestConsumedId) {
        this.partition = Preconditions.checkNotNull(partition);
        this.stopCursor = Preconditions.checkNotNull(stopCursor);
        this.latestConsumedId = latestConsumedId;
    }

    public TopicPartition getPartition() {
        return this.partition;
    }

    public StopCursor getStopCursor() {
        return this.stopCursor;
    }

    @Nullable
    public MessageId getLatestConsumedId() {
        return this.latestConsumedId;
    }

    public String splitId() {
        return this.partition.getFullTopicName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarPartitionSplit that = (PulsarPartitionSplit)o;
        return this.partition.equals(that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.partition);
    }

    public void setLatestConsumedId(MessageId latestConsumedId) {
        this.latestConsumedId = latestConsumedId;
    }

    public PulsarPartitionSplit copy() {
        return new PulsarPartitionSplit(this.partition, this.stopCursor, this.latestConsumedId);
    }
}

