/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.config;

import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.BasePulsarConfig;

public class PulsarClientConfig
extends BasePulsarConfig {
    private static final long serialVersionUID = 1L;
    private final String serviceUrl;

    private PulsarClientConfig(String authPluginClassName, String authParams, String serviceUrl) {
        super(authPluginClassName, authParams);
        this.serviceUrl = serviceUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String authPluginClassName = "";
        private String authParams = "";
        private String serviceUrl;

        private Builder() {
        }

        public Builder authPluginClassName(String authPluginClassName) {
            this.authPluginClassName = authPluginClassName;
            return this;
        }

        public Builder authParams(String authParams) {
            this.authParams = authParams;
            return this;
        }

        public Builder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public PulsarClientConfig build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.serviceUrl), "Pulsar service URL is required.");
            return new PulsarClientConfig(this.authPluginClassName, this.authParams, this.serviceUrl);
        }
    }
}

