/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.sink;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarClientConfig;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.SourceProperties;
import org.apache.seatunnel.connectors.seatunnel.pulsar.sink.PulsarSinkCommitter;
import org.apache.seatunnel.connectors.seatunnel.pulsar.sink.PulsarSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.pulsar.state.PulsarAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.pulsar.state.PulsarCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.pulsar.state.PulsarSinkState;

public class PulsarSink
implements SeaTunnelSink<SeaTunnelRow, PulsarSinkState, PulsarCommitInfo, PulsarAggregatedCommitInfo> {
    private final SeaTunnelRowType seaTunnelRowType;
    private final PulsarClientConfig clientConfig;
    private final ReadonlyConfig readonlyConfig;
    private final CatalogTable catalogTable;

    public PulsarSink(ReadonlyConfig readonlyConfig, CatalogTable catalogTable) {
        this.readonlyConfig = readonlyConfig;
        this.seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        this.catalogTable = catalogTable;
        PulsarClientConfig.Builder clientConfigBuilder = PulsarClientConfig.builder().serviceUrl((String)readonlyConfig.get(SourceProperties.CLIENT_SERVICE_URL));
        clientConfigBuilder.authPluginClassName((String)readonlyConfig.get(SourceProperties.AUTH_PLUGIN_CLASS));
        clientConfigBuilder.authParams((String)readonlyConfig.get(SourceProperties.AUTH_PARAMS));
        this.clientConfig = clientConfigBuilder.build();
    }

    public SinkWriter<SeaTunnelRow, PulsarCommitInfo, PulsarSinkState> createWriter(SinkWriter.Context context) {
        return new PulsarSinkWriter(context, this.clientConfig, this.seaTunnelRowType, this.readonlyConfig, Collections.emptyList());
    }

    public SinkWriter<SeaTunnelRow, PulsarCommitInfo, PulsarSinkState> restoreWriter(SinkWriter.Context context, List<PulsarSinkState> states) {
        return new PulsarSinkWriter(context, this.clientConfig, this.seaTunnelRowType, this.readonlyConfig, states);
    }

    public Optional<Serializer<PulsarSinkState>> getWriterStateSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<SinkCommitter<PulsarCommitInfo>> createCommitter() {
        return Optional.of(new PulsarSinkCommitter(this.clientConfig));
    }

    public Optional<Serializer<PulsarCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public String getPluginName() {
        return "Pulsar";
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.ofNullable(this.catalogTable);
    }
}

