/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.start;

import java.io.Serializable;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.start.MessageIdStartCursor;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.start.SubscriptionStartCursor;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.cursor.start.TimestampStartCursor;

@FunctionalInterface
public interface StartCursor
extends Serializable {
    public void seekPosition(Consumer<?> var1) throws PulsarClientException;

    public static StartCursor earliest() {
        return StartCursor.fromMessageId(MessageId.earliest);
    }

    public static StartCursor latest() {
        return StartCursor.fromMessageId(MessageId.latest);
    }

    public static StartCursor subscription() {
        return new SubscriptionStartCursor();
    }

    public static StartCursor subscription(SubscriptionStartCursor.CursorResetStrategy cursorResetStrategy) {
        return new SubscriptionStartCursor(cursorResetStrategy);
    }

    public static StartCursor fromMessageId(MessageId messageId) {
        return StartCursor.fromMessageId(messageId, true);
    }

    public static StartCursor fromMessageId(MessageId messageId, boolean inclusive) {
        return new MessageIdStartCursor(messageId, inclusive);
    }

    public static StartCursor timestamp(long timestamp) {
        return new TimestampStartCursor(timestamp);
    }
}

