/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.client.admin.Functions;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsData;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataImpl;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.FunctionStatsImpl;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseBodyPart;
import org.apache.pulsar.shade.org.asynchttpclient.HttpResponseStatus;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsImpl
extends ComponentResource
implements Functions {
    private static final Logger log = LoggerFactory.getLogger(FunctionsImpl.class);
    private final WebTarget functions;
    private final AsyncHttpClient asyncHttpClient;

    public FunctionsImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.functions = web.path("/admin/v3/functions");
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public List<String> getFunctions(String tenant, String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getFunctionsAsync(tenant, namespace));
    }

    @Override
    public CompletableFuture<List<String>> getFunctionsAsync(String tenant, String namespace) {
        WebTarget path = this.functions.path(tenant).path(namespace);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    List<String> functions = response.readEntity(new GenericType<List<String>>(){});
                    future.complete(functions);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public FunctionConfig getFunction(String tenant, String namespace, String function) throws PulsarAdminException {
        return (FunctionConfig)this.sync(() -> this.getFunctionAsync(tenant, namespace, function));
    }

    @Override
    public CompletableFuture<FunctionConfig> getFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function);
        final CompletableFuture<FunctionConfig> future = new CompletableFuture<FunctionConfig>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionConfig.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public FunctionStatus getFunctionStatus(String tenant, String namespace, String function) throws PulsarAdminException {
        return (FunctionStatus)this.sync(() -> this.getFunctionStatusAsync(tenant, namespace, function));
    }

    @Override
    public CompletableFuture<FunctionStatus> getFunctionStatusAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("status");
        final CompletableFuture<FunctionStatus> future = new CompletableFuture<FunctionStatus>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionStatus.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionStatus(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        return (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)this.sync(() -> this.getFunctionStatusAsync(tenant, namespace, function, id));
    }

    @Override
    public CompletableFuture<FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData> getFunctionStatusAsync(String tenant, String namespace, String function, int id) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("status");
        final CompletableFuture<FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData> future = new CompletableFuture<FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public FunctionInstanceStatsData getFunctionStats(String tenant, String namespace, String function, int id) throws PulsarAdminException {
        return (FunctionInstanceStatsData)this.sync(() -> this.getFunctionStatsAsync(tenant, namespace, function, id));
    }

    @Override
    public CompletableFuture<FunctionInstanceStatsData> getFunctionStatsAsync(String tenant, String namespace, String function, int id) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(id)).path("stats");
        final CompletableFuture<FunctionInstanceStatsData> future = new CompletableFuture<FunctionInstanceStatsData>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete((FunctionInstanceStatsData)response.readEntity(FunctionInstanceStatsDataImpl.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public FunctionStats getFunctionStats(String tenant, String namespace, String function) throws PulsarAdminException {
        return (FunctionStats)this.sync(() -> this.getFunctionStatsAsync(tenant, namespace, function));
    }

    @Override
    public CompletableFuture<FunctionStats> getFunctionStatsAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("stats");
        final CompletableFuture<FunctionStats> future = new CompletableFuture<FunctionStats>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete((FunctionStats)response.readEntity(FunctionStatsImpl.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void createFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        this.sync(() -> this.createFunctionAsync(functionConfig, fileName));
    }

    @Override
    public CompletableFuture<Void> createFunctionAsync(FunctionConfig functionConfig, String fileName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.post(this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("functionConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(functionConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public void createFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        this.sync(() -> this.createFunctionWithUrlAsync(functionConfig, pkgUrl));
    }

    @Override
    public CompletableFuture<Void> createFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl) {
        WebTarget path = this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName());
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
        mp.bodyPart(new FormDataBodyPart("functionConfig", (Object)new Gson().toJson(functionConfig), MediaType.APPLICATION_JSON_TYPE));
        return this.asyncPostRequest(path, Entity.entity(mp, "multipart/form-data"));
    }

    @Override
    public void deleteFunction(String cluster, String namespace, String function) throws PulsarAdminException {
        this.sync(() -> this.deleteFunctionAsync(cluster, namespace, function));
    }

    @Override
    public CompletableFuture<Void> deleteFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void updateFunction(FunctionConfig functionConfig, String fileName) throws PulsarAdminException {
        this.updateFunction(functionConfig, fileName, null);
    }

    @Override
    public CompletableFuture<Void> updateFunctionAsync(FunctionConfig functionConfig, String fileName) {
        return this.updateFunctionAsync(functionConfig, fileName, null);
    }

    @Override
    public void updateFunction(FunctionConfig functionConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        this.sync(() -> this.updateFunctionAsync(functionConfig, fileName, updateOptions));
    }

    @Override
    public CompletableFuture<Void> updateFunctionAsync(FunctionConfig functionConfig, String fileName, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.put(this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("functionConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(functionConfig), "application/json"));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                builder.addBodyPart(new StringPart("updateOptions", ObjectMapperFactory.getThreadLocal().writeValueAsString(options), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
        }
        return future;
    }

    @Override
    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        this.sync(() -> this.updateFunctionWithUrlAsync(functionConfig, pkgUrl, updateOptions));
    }

    @Override
    public CompletableFuture<Void> updateFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("functionConfig", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(functionConfig), MediaType.APPLICATION_JSON_TYPE));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                mp.bodyPart(new FormDataBodyPart("updateOptions", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(options), MediaType.APPLICATION_JSON_TYPE));
            }
            WebTarget path = this.functions.path(functionConfig.getTenant()).path(functionConfig.getNamespace()).path(functionConfig.getName());
            return this.asyncPutRequest(path, Entity.entity(mp, "multipart/form-data"));
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
            return future;
        }
    }

    @Override
    public void updateFunctionWithUrl(FunctionConfig functionConfig, String pkgUrl) throws PulsarAdminException {
        this.updateFunctionWithUrl(functionConfig, pkgUrl, null);
    }

    @Override
    public CompletableFuture<Void> updateFunctionWithUrlAsync(FunctionConfig functionConfig, String pkgUrl) {
        return this.updateFunctionWithUrlAsync(functionConfig, pkgUrl, null);
    }

    @Override
    public String triggerFunction(String tenant, String namespace, String functionName, String topic, String triggerValue, String triggerFile) throws PulsarAdminException {
        return (String)this.sync(() -> this.triggerFunctionAsync(tenant, namespace, functionName, topic, triggerValue, triggerFile));
    }

    @Override
    public CompletableFuture<String> triggerFunctionAsync(String tenant, String namespace, String function, String topic, String triggerValue, String triggerFile) {
        FormDataMultiPart mp = new FormDataMultiPart();
        if (triggerFile != null) {
            mp.bodyPart(new FileDataBodyPart("dataStream", new File(triggerFile), MediaType.APPLICATION_OCTET_STREAM_TYPE));
        }
        if (triggerValue != null) {
            mp.bodyPart(new FormDataBodyPart("data", (Object)triggerValue, MediaType.TEXT_PLAIN_TYPE));
        }
        if (topic != null && !topic.isEmpty()) {
            mp.bodyPart(new FormDataBodyPart("topic", (Object)topic, MediaType.TEXT_PLAIN_TYPE));
        }
        final WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("trigger");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            this.request(path).async().post(Entity.entity(mp, "multipart/form-data"), new InvocationCallback<String>(){

                @Override
                public void completed(String response) {
                    future.complete(response);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)path.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    @Override
    public void restartFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.restartFunctionAsync(tenant, namespace, functionName, instanceId));
    }

    @Override
    public CompletableFuture<Void> restartFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void restartFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.sync(() -> this.restartFunctionAsync(tenant, namespace, functionName));
    }

    @Override
    public CompletableFuture<Void> restartFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void stopFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.stopFunctionAsync(tenant, namespace, functionName, instanceId));
    }

    @Override
    public CompletableFuture<Void> stopFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void stopFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.sync(() -> this.stopFunctionAsync(tenant, namespace, functionName));
    }

    @Override
    public CompletableFuture<Void> stopFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void startFunction(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        this.sync(() -> this.startFunctionAsync(tenant, namespace, functionName, instanceId));
    }

    @Override
    public CompletableFuture<Void> startFunctionAsync(String tenant, String namespace, String function, int instanceId) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path(Integer.toString(instanceId)).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void startFunction(String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.sync(() -> this.startFunctionAsync(tenant, namespace, functionName));
    }

    @Override
    public CompletableFuture<Void> startFunctionAsync(String tenant, String namespace, String function) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void uploadFunction(String sourceFile, String path) throws PulsarAdminException {
        this.sync(() -> this.uploadFunctionAsync(sourceFile, path));
    }

    @Override
    public CompletableFuture<Void> uploadFunctionAsync(String sourceFile, String path) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.post(this.functions.path("upload").getUri().toASCIIString()).addBodyPart(new FilePart("data", new File(sourceFile), "application/octet-stream"))).addBodyPart(new StringPart("path", path, "text/plain"));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
        }
        return future;
    }

    @Override
    public void downloadFunction(String destinationPath, String tenant, String namespace, String functionName) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download"));
    }

    @Override
    public CompletableFuture<Void> downloadFunctionAsync(String destinationPath, String tenant, String namespace, String functionName) {
        return this.downloadFileAsync(destinationPath, this.functions.path(tenant).path(namespace).path(functionName).path("download"));
    }

    @Override
    public void downloadFunction(String destinationPath, String path) throws PulsarAdminException {
        this.downloadFile(destinationPath, this.functions.path("download").queryParam("path", path));
    }

    @Override
    public CompletableFuture<Void> downloadFunctionAsync(String destinationFile, String path) {
        return this.downloadFileAsync(destinationFile, this.functions.path("download").queryParam("path", path));
    }

    private void downloadFile(String destinationPath, WebTarget target) throws PulsarAdminException {
        this.sync(() -> this.downloadFileAsync(destinationPath, target));
    }

    private CompletableFuture<Void> downloadFileAsync(String destinationPath, WebTarget target) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            File file = new File(destinationPath);
            if (!file.exists()) {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            final FileChannel os = new FileOutputStream(new File(destinationPath)).getChannel();
            RequestBuilder builder = Dsl.get(target.getUri().toASCIIString());
            CompletableFuture<HttpResponseStatus> statusFuture = this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build(), new AsyncHandler<HttpResponseStatus>(){
                private HttpResponseStatus status;

                @Override
                public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    if (this.status.getStatusCode() != Response.Status.OK.getStatusCode()) {
                        return AsyncHandler.State.ABORT;
                    }
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    os.write(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.State.CONTINUE;
                }

                @Override
                public HttpResponseStatus onCompleted() throws Exception {
                    return this.status;
                }

                @Override
                public void onThrowable(Throwable t) {
                }
            }).toCompletableFuture();
            ((CompletableFuture)((CompletableFuture)statusFuture.whenComplete((status, throwable) -> {
                try {
                    os.close();
                }
                catch (IOException e) {
                    future.completeExceptionally(FunctionsImpl.getApiException(e));
                }
            })).thenAccept(status -> {
                if (status.getStatusCode() < 200 || status.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(status.getStatusCode()).entity(status.getStatusText()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(FunctionsImpl.getApiException(e));
        }
        return future;
    }

    @Override
    public List<ConnectorDefinition> getConnectorsList() throws PulsarAdminException {
        try {
            Response response = this.request(this.functions.path("connectors")).get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw this.getApiException(response);
            }
            return response.readEntity(new GenericType<List<ConnectorDefinition>>(){});
        }
        catch (Exception e) {
            throw FunctionsImpl.getApiException(e);
        }
    }

    @Override
    public Set<String> getSources() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty(c.getSourceClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getSinks() throws PulsarAdminException {
        return this.getConnectorsList().stream().filter(c -> !StringUtils.isEmpty(c.getSinkClass())).map(ConnectorDefinition::getName).collect(Collectors.toSet());
    }

    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        try {
            return this.request(this.functions.path("cluster")).get(new GenericType<List<WorkerInfo>>(){});
        }
        catch (Exception e) {
            throw FunctionsImpl.getApiException(e);
        }
    }

    @Override
    public FunctionState getFunctionState(String tenant, String namespace, String function, String key) throws PulsarAdminException {
        return (FunctionState)this.sync(() -> this.getFunctionStateAsync(tenant, namespace, function, key));
    }

    @Override
    public CompletableFuture<FunctionState> getFunctionStateAsync(String tenant, String namespace, String function, String key) {
        WebTarget path = this.functions.path(tenant).path(namespace).path(function).path("state").path(key);
        final CompletableFuture<FunctionState> future = new CompletableFuture<FunctionState>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(FunctionsImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(FunctionState.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void putFunctionState(String tenant, String namespace, String function, FunctionState state) throws PulsarAdminException {
        this.sync(() -> this.putFunctionStateAsync(tenant, namespace, function, state));
    }

    @Override
    public CompletableFuture<Void> putFunctionStateAsync(String tenant, String namespace, String function, FunctionState state) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = Dsl.post(this.functions.path(tenant).path(namespace).path(function).path("state").path(state.getKey()).getUri().toASCIIString());
            builder.addBodyPart(new StringPart("state", ObjectMapperFactory.getThreadLocal().writeValueAsString(state), "application/json"));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void updateOnWorkerLeader(String tenant, String namespace, String function, byte[] functionMetaData, boolean delete) throws PulsarAdminException {
        this.sync(() -> this.updateOnWorkerLeaderAsync(tenant, namespace, function, functionMetaData, delete));
    }

    public CompletableFuture<Void> updateOnWorkerLeaderAsync(String tenant, String namespace, String function, byte[] functionMetaData, boolean delete) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)Dsl.put(this.functions.path("leader").path(tenant).path(namespace).path(function).getUri().toASCIIString()).addBodyPart(new ByteArrayPart("functionMetaData", functionMetaData))).addBodyPart(new StringPart("delete", Boolean.toString(delete)));
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.functions, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(FunctionsImpl.getApiException(throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }
}

