/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.config;

import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.BasePulsarConfig;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarAdminConfig;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarClientConfig;
import org.apache.seatunnel.connectors.seatunnel.pulsar.config.PulsarConsumerConfig;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorException;

public class PulsarConfigUtil {
    public static final String IDENTIFIER = "pulsar";

    private PulsarConfigUtil() {
    }

    public static PulsarAdmin createAdmin(PulsarAdminConfig config) {
        PulsarAdminBuilder builder = PulsarAdmin.builder();
        builder.serviceHttpUrl(config.getAdminUrl());
        builder.authentication(PulsarConfigUtil.createAuthentication(config));
        try {
            return builder.build();
        }
        catch (PulsarClientException e) {
            throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.OPEN_PULSAR_ADMIN_FAILED, e);
        }
    }

    public static PulsarClient createClient(PulsarClientConfig config) {
        ClientBuilder builder = PulsarClient.builder();
        builder.serviceUrl(config.getServiceUrl());
        builder.authentication(PulsarConfigUtil.createAuthentication(config));
        try {
            return builder.build();
        }
        catch (PulsarClientException e) {
            throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.OPEN_PULSAR_CLIENT_FAILED, e);
        }
    }

    public static ConsumerBuilder<byte[]> createConsumerBuilder(PulsarClient client, PulsarConsumerConfig config) {
        ConsumerBuilder<byte[]> builder = client.newConsumer(Schema.BYTES);
        builder.subscriptionName(config.getSubscriptionName());
        return builder;
    }

    private static Authentication createAuthentication(BasePulsarConfig config) {
        if (StringUtils.isBlank(config.getAuthPluginClassName())) {
            return AuthenticationDisabled.INSTANCE;
        }
        if (StringUtils.isNotBlank(config.getAuthPluginClassName())) {
            try {
                return AuthenticationFactory.create(config.getAuthPluginClassName(), config.getAuthParams());
            }
            catch (PulsarClientException.UnsupportedAuthenticationException e) {
                throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.PULSAR_AUTHENTICATION_FAILED, e);
            }
        }
        throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.PULSAR_AUTHENTICATION_FAILED, "Authentication parameters are required when using authentication plug-in.");
    }
}

