/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.discoverer;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.pulsar.exception.PulsarConnectorException;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.discoverer.PulsarDiscoverer;
import org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.topic.TopicPartition;

public class TopicListDiscoverer
implements PulsarDiscoverer {
    private final List<String> topics;

    public TopicListDiscoverer(List<String> topics) {
        this.topics = topics;
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(PulsarAdmin pulsarAdmin) {
        return this.topics.parallelStream().map(topicName -> {
            String completeTopicName = TopicName.get(topicName).getPartitionedTopicName();
            try {
                PartitionedTopicMetadata metadata = pulsarAdmin.topics().getPartitionedTopicMetadata(completeTopicName);
                return PulsarDiscoverer.toTopicPartitions(topicName, metadata.partitions);
            }
            catch (PulsarAdminException e) {
                throw new PulsarConnectorException((SeaTunnelErrorCode)PulsarConnectorErrorCode.SUBSCRIBE_TOPIC_FAILED, e);
            }
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

