/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.pulsar.source.enumerator.topic;

import java.io.Serializable;
import java.util.Objects;
import org.apache.pulsar.common.naming.TopicName;

public class TopicPartition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int hash = 0;
    private final String topic;
    private final int partition;

    public TopicPartition(String topic, int partition) {
        this.topic = topic;
        this.partition = partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public String getFullTopicName() {
        if (this.partition < 0) {
            return this.topic;
        }
        return TopicName.get(this.topic).getPartition(this.partition).toString();
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.partition;
        this.hash = result = 31 * result + Objects.hashCode(this.topic);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicPartition other = (TopicPartition)obj;
        return this.partition == other.partition && Objects.equals(this.topic, other.topic);
    }
}

