/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqConfig;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.sink.RabbitmqSinkWriter;

public class RabbitmqSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private final RabbitmqConfig rabbitMQConfig;
    private final CatalogTable catalogTable;

    public String getPluginName() {
        return "RabbitMQ";
    }

    public RabbitmqSink(RabbitmqConfig rabbitMQConfig, CatalogTable catalogTable) {
        this.rabbitMQConfig = rabbitMQConfig;
        this.catalogTable = catalogTable;
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new RabbitmqSinkWriter(this.rabbitMQConfig, this.catalogTable.getSeaTunnelRowType());
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.of(this.catalogTable);
    }
}

