/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.source;

import com.google.common.base.Preconditions;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Delivery;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.Handover;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.client.RabbitmqClient;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqConfig;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.exception.RabbitmqConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.exception.RabbitmqConnectorException;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.split.RabbitmqSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitmqSourceReader<T>
implements SourceReader<T, RabbitmqSplit> {
    private static final Logger log = LoggerFactory.getLogger(RabbitmqSourceReader.class);
    protected final Handover<Delivery> handover = new Handover();
    protected final SourceReader.Context context;
    protected transient Channel channel;
    private final boolean usesCorrelationId;
    protected transient boolean autoAck;
    protected transient Set<String> correlationIdsProcessedButNotAcknowledged;
    protected transient List<Long> deliveryTagsProcessedForCurrentSnapshot;
    protected final SortedMap<Long, List<Long>> pendingDeliveryTagsToCommit = Collections.synchronizedSortedMap(new TreeMap());
    protected final SortedMap<Long, Set<String>> pendingCorrelationIdsToCommit = Collections.synchronizedSortedMap(new TreeMap());
    private final DeserializationSchema<SeaTunnelRow> deserializationSchema;
    private RabbitmqClient rabbitMQClient;
    private DefaultConsumer consumer;
    private final RabbitmqConfig config;

    public RabbitmqSourceReader(DeserializationSchema<SeaTunnelRow> deserializationSchema, SourceReader.Context context, RabbitmqConfig config) {
        this.context = context;
        this.deserializationSchema = deserializationSchema;
        this.config = config;
        this.rabbitMQClient = new RabbitmqClient(config);
        this.channel = this.rabbitMQClient.getChannel();
        this.usesCorrelationId = config.isUsesCorrelationId();
    }

    public void open() throws Exception {
        this.correlationIdsProcessedButNotAcknowledged = new HashSet<String>();
        this.deliveryTagsProcessedForCurrentSnapshot = new ArrayList<Long>();
        this.consumer = this.rabbitMQClient.getQueueingConsumer(this.handover);
        if (Boundedness.UNBOUNDED.equals((Object)this.context.getBoundedness())) {
            this.autoAck = false;
            this.channel.txSelect();
        } else {
            this.autoAck = true;
        }
        log.debug("Starting RabbitMQ source with autoAck status: " + this.autoAck);
        this.channel.basicConsume(this.config.getQueueName(), this.autoAck, this.consumer);
    }

    public void close() throws IOException {
        if (this.rabbitMQClient != null) {
            this.rabbitMQClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector output) throws Exception {
        Optional deliveryOptional = this.handover.pollNext();
        if (deliveryOptional.isPresent()) {
            Delivery delivery = (Delivery)deliveryOptional.get();
            AMQP.BasicProperties properties = delivery.getProperties();
            String correlationId = Objects.isNull(properties) ? null : properties.getCorrelationId();
            byte[] body = delivery.getBody();
            Envelope envelope = delivery.getEnvelope();
            Object object = output.getCheckpointLock();
            synchronized (object) {
                boolean newMessage = this.verifyMessageIdentifier(properties.getCorrelationId(), envelope.getDeliveryTag());
                if (!newMessage) {
                    return;
                }
                this.deliveryTagsProcessedForCurrentSnapshot.add(envelope.getDeliveryTag());
                this.deserializationSchema.deserialize(body, output);
            }
            if (Boundedness.BOUNDED.equals((Object)this.context.getBoundedness())) {
                this.context.signalNoMoreElement();
            }
        }
    }

    public List<RabbitmqSplit> snapshotState(long checkpointId) throws Exception {
        List<RabbitmqSplit> pendingSplit = Collections.singletonList(new RabbitmqSplit(this.deliveryTagsProcessedForCurrentSnapshot, this.correlationIdsProcessedButNotAcknowledged));
        List deliveryTags = this.pendingDeliveryTagsToCommit.computeIfAbsent(checkpointId, id -> new ArrayList());
        Set correlationIds = this.pendingCorrelationIdsToCommit.computeIfAbsent(checkpointId, id -> new HashSet());
        for (RabbitmqSplit split : pendingSplit) {
            List<Long> currentCheckPointDeliveryTags = split.getDeliveryTags();
            Set<String> currentCheckPointCorrelationIds = split.getCorrelationIds();
            if (currentCheckPointDeliveryTags != null) {
                deliveryTags.addAll(currentCheckPointDeliveryTags);
            }
            if (currentCheckPointCorrelationIds == null) continue;
            correlationIds.addAll(currentCheckPointCorrelationIds);
        }
        this.deliveryTagsProcessedForCurrentSnapshot.clear();
        return pendingSplit;
    }

    public void addSplits(List splits) {
    }

    public void handleNoMoreSplits() {
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        log.debug("Committing cursors for checkpoint {}", (Object)checkpointId);
        List pendingDeliveryTags = (List)this.pendingDeliveryTagsToCommit.remove(checkpointId);
        Set pendingCorrelationIds = (Set)this.pendingCorrelationIdsToCommit.remove(checkpointId);
        if (pendingDeliveryTags == null || pendingCorrelationIds == null) {
            log.debug("pending delivery tags or correlationIds checkpoint {} either do not exist or have already been committed.", (Object)checkpointId);
            return;
        }
        if (!this.autoAck) {
            this.acknowledgeDeliveryTags(pendingDeliveryTags);
        }
        this.correlationIdsProcessedButNotAcknowledged.removeAll(pendingCorrelationIds);
    }

    protected void acknowledgeDeliveryTags(List<Long> deliveryTags) {
        try {
            for (long id : deliveryTags) {
                this.channel.basicAck(id, false);
            }
            this.channel.txCommit();
        }
        catch (IOException e) {
            throw new RabbitmqConnectorException((SeaTunnelErrorCode)RabbitmqConnectorErrorCode.MESSAGE_ACK_FAILED, e);
        }
    }

    public boolean verifyMessageIdentifier(String correlationId, long deliveryTag) {
        if (!this.autoAck && this.usesCorrelationId) {
            Preconditions.checkNotNull((Object)correlationId, (Object)"RabbitMQ source was instantiated with usesCorrelationId set to true yet we couldn't extract the correlation id from it!");
            if (!this.correlationIdsProcessedButNotAcknowledged.add(correlationId)) {
                try {
                    this.channel.basicReject(deliveryTag, false);
                }
                catch (IOException e) {
                    throw new RabbitmqConnectorException((SeaTunnelErrorCode)RabbitmqConnectorErrorCode.MESSAGE_ACK_REJECTED, e);
                }
                return false;
            }
        }
        return true;
    }
}

