/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class RabbitmqConfig
implements Serializable {
    private String host;
    private Integer port;
    private String virtualHost;
    private String username;
    private String password;
    private String uri;
    private Integer networkRecoveryInterval;
    private Boolean automaticRecovery;
    private Boolean topologyRecovery;
    private Integer connectionTimeout;
    private Integer requestedChannelMax;
    private Integer requestedFrameMax;
    private Integer requestedHeartbeat;
    private Integer prefetchCount;
    private long deliveryTimeout;
    private String queueName;
    private Boolean durable;
    private Boolean exclusive;
    private Boolean autoDelete;
    private String routingKey;
    private boolean logFailuresOnly = false;
    private String exchange = "";
    private boolean forE2ETesting = false;
    private boolean usesCorrelationId = false;
    private final Map<String, Object> sinkOptionProps = new HashMap<String, Object>();
    public static final Option<String> HOST = Options.key((String)"host").stringType().noDefaultValue().withDescription("the default host to use for connections");
    public static final Option<Integer> PORT = Options.key((String)"port").intType().noDefaultValue().withDescription("the default port to use for connections");
    public static final Option<String> VIRTUAL_HOST = Options.key((String)"virtual_host").stringType().noDefaultValue().withDescription("the virtual host to use when connecting to the broker");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("the AMQP user name to use when connecting to the broker");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("the password to use when connecting to the broker");
    public static final Option<String> QUEUE_NAME = Options.key((String)"queue_name").stringType().noDefaultValue().withDescription("the queue to write the message to");
    public static final Option<String> URL = Options.key((String)"url").stringType().noDefaultValue().withDescription("convenience method for setting the fields in an AMQP URI: host, port, username, password and virtual host");
    public static final Option<Integer> NETWORK_RECOVERY_INTERVAL = Options.key((String)"network_recovery_interval").intType().noDefaultValue().withDescription("how long will automatic recovery wait before attempting to reconnect, in ms");
    public static final Option<Boolean> AUTOMATIC_RECOVERY_ENABLED = Options.key((String)"AUTOMATIC_RECOVERY_ENABLED").booleanType().noDefaultValue().withDescription("if true, enables connection recovery");
    public static final Option<Boolean> TOPOLOGY_RECOVERY_ENABLED = Options.key((String)"topology_recovery_enabled").booleanType().noDefaultValue().withDescription("if true, enables topology recovery");
    public static final Option<Integer> CONNECTION_TIMEOUT = Options.key((String)"connection_timeout").intType().noDefaultValue().withDescription("connection TCP establishment timeout in milliseconds");
    public static final Option<Integer> REQUESTED_CHANNEL_MAX = Options.key((String)"requested_channel_max").intType().noDefaultValue().withDescription("initially requested maximum channel number");
    public static final Option<Integer> REQUESTED_FRAME_MAX = Options.key((String)"requested_frame_max").intType().noDefaultValue().withDescription("the requested maximum frame size");
    public static final Option<Integer> REQUESTED_HEARTBEAT = Options.key((String)"requested_heartbeat").intType().noDefaultValue().withDescription("the requested heartbeat timeout");
    public static final Option<Long> PREFETCH_COUNT = Options.key((String)"prefetch_count").longType().noDefaultValue().withDescription("prefetchCount the max number of messages to receive without acknowledgement\n");
    public static final Option<Integer> DELIVERY_TIMEOUT = Options.key((String)"delivery_timeout").intType().noDefaultValue().withDescription("deliveryTimeout maximum wait time");
    public static final Option<String> ROUTING_KEY = Options.key((String)"routing_key").stringType().noDefaultValue().withDescription("the routing key to publish the message to");
    public static final Option<String> EXCHANGE = Options.key((String)"exchange").stringType().noDefaultValue().withDescription("the exchange to publish the message to");
    public static final Option<Boolean> FOR_E2E_TESTING = Options.key((String)"for_e2e_testing").booleanType().noDefaultValue().withDescription("use to recognize E2E mode");
    public static final Option<Map<String, String>> RABBITMQ_CONFIG = Options.key((String)"rabbitmq.config").mapType().defaultValue(Collections.emptyMap()).withDescription("In addition to the above parameters that must be specified by the RabbitMQ client, the user can also specify multiple non-mandatory parameters for the client, covering [all the parameters specified in the official RabbitMQ document](https://www.rabbitmq.com/configure.html).");
    public static final Option<Boolean> USE_CORRELATION_ID = Options.key((String)"use_correlation_id").booleanType().noDefaultValue().withDescription("Whether the messages received are supplied with a uniqueid to deduplicate messages (in case of failed acknowledgments).");
    public static final Option<Boolean> DURABLE = Options.key((String)"durable").booleanType().defaultValue((Object)true).withDescription("true: The queue will survive a server restart.false: The queue will be deleted on server restart.");
    public static final Option<Boolean> EXCLUSIVE = Options.key((String)"exclusive").booleanType().defaultValue((Object)false).withDescription("true: The queue is used only by the current connection and will be deleted when the connection closes.false: The queue can be used by multiple connections.");
    public static final Option<Boolean> AUTO_DELETE = Options.key((String)"auto_delete").booleanType().defaultValue((Object)false).withDescription("true: The queue will be deleted automatically when the last consumer unsubscribes.false: The queue will not be automatically deleted.");

    private void parseSinkOptionProperties(Config pluginConfig) {
        if (CheckConfigUtil.isValidParam((Config)pluginConfig, (String)RABBITMQ_CONFIG.key())) {
            pluginConfig.getObject(RABBITMQ_CONFIG.key()).forEach((key, value) -> {
                String configKey = key.toLowerCase();
                this.sinkOptionProps.put(configKey, value.unwrapped());
            });
        }
    }

    public RabbitmqConfig(Config config) {
        this.host = config.getString(HOST.key());
        this.port = config.getInt(PORT.key());
        this.queueName = config.getString(QUEUE_NAME.key());
        if (config.hasPath(USERNAME.key())) {
            this.username = config.getString(USERNAME.key());
        }
        if (config.hasPath(PASSWORD.key())) {
            this.password = config.getString(PASSWORD.key());
        }
        if (config.hasPath(VIRTUAL_HOST.key())) {
            this.virtualHost = config.getString(VIRTUAL_HOST.key());
        }
        if (config.hasPath(NETWORK_RECOVERY_INTERVAL.key())) {
            this.networkRecoveryInterval = config.getInt(NETWORK_RECOVERY_INTERVAL.key());
        }
        if (config.hasPath(AUTOMATIC_RECOVERY_ENABLED.key())) {
            this.automaticRecovery = config.getBoolean(AUTOMATIC_RECOVERY_ENABLED.key());
        }
        if (config.hasPath(TOPOLOGY_RECOVERY_ENABLED.key())) {
            this.topologyRecovery = config.getBoolean(TOPOLOGY_RECOVERY_ENABLED.key());
        }
        if (config.hasPath(CONNECTION_TIMEOUT.key())) {
            this.connectionTimeout = config.getInt(CONNECTION_TIMEOUT.key());
        }
        if (config.hasPath(REQUESTED_CHANNEL_MAX.key())) {
            this.requestedChannelMax = config.getInt(REQUESTED_CHANNEL_MAX.key());
        }
        if (config.hasPath(REQUESTED_FRAME_MAX.key())) {
            this.requestedFrameMax = config.getInt(REQUESTED_FRAME_MAX.key());
        }
        if (config.hasPath(REQUESTED_HEARTBEAT.key())) {
            this.requestedHeartbeat = config.getInt(REQUESTED_HEARTBEAT.key());
        }
        if (config.hasPath(PREFETCH_COUNT.key())) {
            this.prefetchCount = config.getInt(PREFETCH_COUNT.key());
        }
        if (config.hasPath(DELIVERY_TIMEOUT.key())) {
            this.deliveryTimeout = config.getInt(DELIVERY_TIMEOUT.key());
        }
        if (config.hasPath(ROUTING_KEY.key())) {
            this.routingKey = config.getString(ROUTING_KEY.key());
        }
        if (config.hasPath(EXCHANGE.key())) {
            this.exchange = config.getString(EXCHANGE.key());
        }
        if (config.hasPath(FOR_E2E_TESTING.key())) {
            this.forE2ETesting = config.getBoolean(FOR_E2E_TESTING.key());
        }
        if (config.hasPath(USE_CORRELATION_ID.key())) {
            this.usesCorrelationId = config.getBoolean(USE_CORRELATION_ID.key());
        }
        if (config.hasPath(DURABLE.key())) {
            this.durable = config.getBoolean(DURABLE.key());
        }
        if (config.hasPath(EXCLUSIVE.key())) {
            this.exclusive = config.getBoolean(EXCLUSIVE.key());
        }
        if (config.hasPath(AUTO_DELETE.key())) {
            this.autoDelete = config.getBoolean(AUTO_DELETE.key());
        }
        this.parseSinkOptionProperties(config);
    }

    @VisibleForTesting
    public RabbitmqConfig() {
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setNetworkRecoveryInterval(Integer networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    public void setAutomaticRecovery(Boolean automaticRecovery) {
        this.automaticRecovery = automaticRecovery;
    }

    public void setTopologyRecovery(Boolean topologyRecovery) {
        this.topologyRecovery = topologyRecovery;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setRequestedChannelMax(Integer requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public void setRequestedFrameMax(Integer requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public void setRequestedHeartbeat(Integer requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public void setPrefetchCount(Integer prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setDeliveryTimeout(long deliveryTimeout) {
        this.deliveryTimeout = deliveryTimeout;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setLogFailuresOnly(boolean logFailuresOnly) {
        this.logFailuresOnly = logFailuresOnly;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setForE2ETesting(boolean forE2ETesting) {
        this.forE2ETesting = forE2ETesting;
    }

    public void setUsesCorrelationId(boolean usesCorrelationId) {
        this.usesCorrelationId = usesCorrelationId;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public Boolean getAutomaticRecovery() {
        return this.automaticRecovery;
    }

    public Boolean getTopologyRecovery() {
        return this.topologyRecovery;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public Integer getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public Integer getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public Integer getPrefetchCount() {
        return this.prefetchCount;
    }

    public long getDeliveryTimeout() {
        return this.deliveryTimeout;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Boolean getDurable() {
        return this.durable;
    }

    public Boolean getExclusive() {
        return this.exclusive;
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public boolean isLogFailuresOnly() {
        return this.logFailuresOnly;
    }

    public String getExchange() {
        return this.exchange;
    }

    public boolean isForE2ETesting() {
        return this.forE2ETesting;
    }

    public boolean isUsesCorrelationId() {
        return this.usesCorrelationId;
    }

    public Map<String, Object> getSinkOptionProps() {
        return this.sinkOptionProps;
    }

    public RabbitmqConfig(String host, Integer port, String virtualHost, String username, String password, String uri, Integer networkRecoveryInterval, Boolean automaticRecovery, Boolean topologyRecovery, Integer connectionTimeout, Integer requestedChannelMax, Integer requestedFrameMax, Integer requestedHeartbeat, Integer prefetchCount, long deliveryTimeout, String queueName, Boolean durable, Boolean exclusive, Boolean autoDelete, String routingKey, boolean logFailuresOnly, String exchange, boolean forE2ETesting, boolean usesCorrelationId) {
        this.host = host;
        this.port = port;
        this.virtualHost = virtualHost;
        this.username = username;
        this.password = password;
        this.uri = uri;
        this.networkRecoveryInterval = networkRecoveryInterval;
        this.automaticRecovery = automaticRecovery;
        this.topologyRecovery = topologyRecovery;
        this.connectionTimeout = connectionTimeout;
        this.requestedChannelMax = requestedChannelMax;
        this.requestedFrameMax = requestedFrameMax;
        this.requestedHeartbeat = requestedHeartbeat;
        this.prefetchCount = prefetchCount;
        this.deliveryTimeout = deliveryTimeout;
        this.queueName = queueName;
        this.durable = durable;
        this.exclusive = exclusive;
        this.autoDelete = autoDelete;
        this.routingKey = routingKey;
        this.logFailuresOnly = logFailuresOnly;
        this.exchange = exchange;
        this.forE2ETesting = forE2ETesting;
        this.usesCorrelationId = usesCorrelationId;
    }
}

