/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClient;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisSingleClient
extends RedisClient {
    public RedisSingleClient(RedisParameters redisParameters, Jedis jedis, int redisVersion) {
        super(redisParameters, jedis, redisVersion);
    }

    @Override
    public List<String> batchGetString(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<String>();
        }
        String[] keyArr = keys.toArray(new String[0]);
        return this.jedis.mget(keyArr);
    }

    @Override
    public List<List<String>> batchGetList(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<List<String>>();
        }
        Pipeline pipeline = this.jedis.pipelined();
        ArrayList<Response<List<String>>> responses = new ArrayList<Response<List<String>>>(keys.size());
        for (String key : keys) {
            responses.add(pipeline.lrange(key, 0L, -1L));
        }
        pipeline.sync();
        ArrayList<List<String>> resultList = new ArrayList<List<String>>(keys.size());
        for (Response response : responses) {
            resultList.add((List)response.get());
        }
        return resultList;
    }

    @Override
    public List<Set<String>> batchGetSet(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<Set<String>>();
        }
        Pipeline pipeline = this.jedis.pipelined();
        ArrayList<Response<Set<String>>> responses = new ArrayList<Response<Set<String>>>(keys.size());
        for (String key : keys) {
            responses.add(pipeline.smembers(key));
        }
        pipeline.sync();
        ArrayList<Set<String>> resultList = new ArrayList<Set<String>>(keys.size());
        for (Response response : responses) {
            resultList.add((Set)response.get());
        }
        return resultList;
    }

    @Override
    public List<Map<String, String>> batchGetHash(List<String> keys) {
        Response response;
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<Map<String, String>>();
        }
        Pipeline pipeline = this.jedis.pipelined();
        ArrayList<Response> responses = new ArrayList<Response>(keys.size());
        for (String key : keys) {
            response = pipeline.hgetAll(key);
            responses.add(response);
        }
        pipeline.sync();
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            response = (Response)responses.get(i);
            Map map = (Map)response.get();
            if (map != null) {
                map.put("hash_key", keys.get(i));
            }
            resultList.add(map);
        }
        return resultList;
    }

    @Override
    public List<List<String>> batchGetZset(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<Response> responses = new ArrayList<Response>(keys.size());
        Pipeline pipelined = this.jedis.pipelined();
        for (String key : keys) {
            Response response = pipelined.zrange(key, 0L, -1L);
            responses.add(response);
        }
        pipelined.sync();
        ArrayList<List<String>> resultlist = new ArrayList<List<String>>(keys.size());
        for (Response response : responses) {
            resultlist.add((List)response.get());
        }
        return resultlist;
    }

    @Override
    public void batchWriteString(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        Pipeline pipelined = this.jedis.pipelined();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            RowKind rowKind = rowKinds.get(i);
            String key = keys.get(i);
            String value = values.get(i);
            if (rowKind == RowKind.DELETE || rowKind == RowKind.UPDATE_BEFORE) {
                pipelined.del(key);
                continue;
            }
            pipelined.set(key, value);
            if (expireSeconds <= 0L) continue;
            pipelined.expire(key, expireSeconds);
        }
        pipelined.sync();
    }

    @Override
    public void batchWriteList(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        Pipeline pipelined = this.jedis.pipelined();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            RowKind rowKind = rowKinds.get(i);
            String key = keys.get(i);
            String value = values.get(i);
            if (rowKind == RowKind.DELETE || rowKind == RowKind.UPDATE_BEFORE) {
                pipelined.lrem(key, 1L, value);
                continue;
            }
            pipelined.lpush(key, value);
            if (expireSeconds <= 0L) continue;
            pipelined.expire(key, expireSeconds);
        }
        pipelined.sync();
    }

    @Override
    public void batchWriteSet(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        Pipeline pipelined = this.jedis.pipelined();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            RowKind rowKind = rowKinds.get(i);
            String key = keys.get(i);
            String value = values.get(i);
            if (rowKind == RowKind.DELETE || rowKind == RowKind.UPDATE_BEFORE) {
                pipelined.srem(key, value);
                continue;
            }
            pipelined.sadd(key, value);
            if (expireSeconds <= 0L) continue;
            pipelined.expire(key, expireSeconds);
        }
        pipelined.sync();
    }

    @Override
    public void batchWriteHash(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        Pipeline pipelined = this.jedis.pipelined();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            RowKind rowKind = rowKinds.get(i);
            String key = keys.get(i);
            String value = values.get(i);
            Map fieldsMap = JsonUtils.toMap((String)value);
            if (rowKind == RowKind.DELETE || rowKind == RowKind.UPDATE_BEFORE) {
                for (Map.Entry entry : fieldsMap.entrySet()) {
                    pipelined.hdel(key, (String)entry.getKey());
                }
                continue;
            }
            pipelined.hset(key, fieldsMap);
            if (expireSeconds <= 0L) continue;
            pipelined.expire(key, expireSeconds);
        }
        pipelined.sync();
    }

    @Override
    public void batchWriteZset(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        Pipeline pipelined = this.jedis.pipelined();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            RowKind rowKind = rowKinds.get(i);
            String key = keys.get(i);
            String value = values.get(i);
            if (rowKind == RowKind.DELETE || rowKind == RowKind.UPDATE_BEFORE) {
                pipelined.zrem(key, value);
                continue;
            }
            pipelined.zadd(key, 1.0, value);
            if (expireSeconds <= 0L) continue;
            pipelined.expire(key, expireSeconds);
        }
        pipelined.sync();
    }
}

