/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.source;

import java.util.List;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.AbstractSingleSplitSource;
import org.apache.seatunnel.connectors.seatunnel.common.source.SingleSplitReaderContext;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import org.apache.seatunnel.connectors.seatunnel.redis.exception.RedisConnectorException;
import org.apache.seatunnel.connectors.seatunnel.redis.source.RedisSourceReader;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;

public class RedisSource
extends AbstractSingleSplitSource<SeaTunnelRow> {
    private final RedisParameters redisParameters = new RedisParameters();
    private SeaTunnelRowType seaTunnelRowType;
    private DeserializationSchema<SeaTunnelRow> deserializationSchema;
    private CatalogTable catalogTable;

    public String getPluginName() {
        return "Redis";
    }

    public RedisSource(ReadonlyConfig readonlyConfig) {
        this.redisParameters.buildWithConfig(readonlyConfig);
        if (readonlyConfig.getOptional(RedisBaseOptions.FORMAT).isPresent()) {
            if (!readonlyConfig.getOptional(SinkConnectorCommonOptions.SCHEMA).isPresent()) {
                throw new RedisConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, "Must config schema when format parameter been config"));
            }
            RedisBaseOptions.Format format = (RedisBaseOptions.Format)((Object)readonlyConfig.get(RedisBaseOptions.FORMAT));
            if (RedisBaseOptions.Format.JSON.equals((Object)format)) {
                this.catalogTable = CatalogTableUtil.buildWithConfig((ReadonlyConfig)readonlyConfig);
                this.seaTunnelRowType = this.catalogTable.getSeaTunnelRowType();
                this.deserializationSchema = new JsonDeserializationSchema(this.catalogTable, false, false);
            }
        } else {
            this.catalogTable = CatalogTableUtil.buildSimpleTextTable();
            this.seaTunnelRowType = this.catalogTable.getSeaTunnelRowType();
            this.deserializationSchema = null;
        }
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Lists.newArrayList((Object[])new CatalogTable[]{this.catalogTable});
    }

    @Override
    public AbstractSingleSplitReader<SeaTunnelRow> createReader(SingleSplitReaderContext readerContext) throws Exception {
        return new RedisSourceReader(this.redisParameters, readerContext, this.deserializationSchema);
    }
}

