/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClient;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import redis.clients.jedis.Jedis;

public class RedisClusterClient
extends RedisClient {
    public RedisClusterClient(RedisParameters redisParameters, Jedis jedis, int redisVersion) {
        super(redisParameters, jedis, redisVersion);
    }

    @Override
    public List<String> batchGetString(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(keys.size());
        for (String key : keys) {
            result.add(this.jedis.get(key));
        }
        return result;
    }

    @Override
    public List<List<String>> batchGetList(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(keys.size());
        for (String key : keys) {
            result.add(this.jedis.lrange(key, 0L, -1L));
        }
        return result;
    }

    @Override
    public List<Set<String>> batchGetSet(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<Set<String>>();
        }
        ArrayList<Set<String>> result = new ArrayList<Set<String>>(keys.size());
        for (String key : keys) {
            result.add(this.jedis.smembers(key));
        }
        return result;
    }

    @Override
    public List<Map<String, String>> batchGetHash(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(keys.size());
        for (String key : keys) {
            Map<String, String> map = this.jedis.hgetAll(key);
            map.put("hash_key", key);
            result.add(map);
        }
        return result;
    }

    @Override
    public List<List<String>> batchGetZset(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>(keys.size());
        for (String key : keys) {
            result.add(this.jedis.zrange(key, 0L, -1L));
        }
        return result;
    }

    @Override
    public void batchWriteString(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            if (rowKinds.get(i) == RowKind.DELETE || rowKinds.get(i) == RowKind.UPDATE_BEFORE) {
                RedisDataType.STRING.del(this, keys.get(i), values.get(i));
                continue;
            }
            RedisDataType.STRING.set(this, keys.get(i), values.get(i), expireSeconds);
        }
    }

    @Override
    public void batchWriteList(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            if (rowKinds.get(i) == RowKind.DELETE || rowKinds.get(i) == RowKind.UPDATE_BEFORE) {
                RedisDataType.LIST.del(this, keys.get(i), values.get(i));
                continue;
            }
            RedisDataType.LIST.set(this, keys.get(i), values.get(i), expireSeconds);
        }
    }

    @Override
    public void batchWriteSet(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            if (rowKinds.get(i) == RowKind.DELETE || rowKinds.get(i) == RowKind.UPDATE_BEFORE) {
                RedisDataType.SET.del(this, keys.get(i), values.get(i));
                continue;
            }
            RedisDataType.SET.set(this, keys.get(i), values.get(i), expireSeconds);
        }
    }

    @Override
    public void batchWriteHash(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            if (rowKinds.get(i) == RowKind.DELETE || rowKinds.get(i) == RowKind.UPDATE_BEFORE) {
                RedisDataType.HASH.del(this, keys.get(i), values.get(i));
                continue;
            }
            RedisDataType.HASH.set(this, keys.get(i), values.get(i), expireSeconds);
        }
    }

    @Override
    public void batchWriteZset(List<RowKind> rowKinds, List<String> keys, List<String> values, long expireSeconds) {
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            if (rowKinds.get(i) == RowKind.DELETE || rowKinds.get(i) == RowKind.UPDATE_BEFORE) {
                RedisDataType.ZSET.del(this, keys.get(i), values.get(i));
                continue;
            }
            RedisDataType.ZSET.set(this, keys.get(i), values.get(i), expireSeconds);
        }
    }
}

