/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;

public class RedisBaseOptions {
    public static final String CONNECTOR_IDENTITY = "Redis";
    public static final Option<String> HOST = Options.key((String)"host").stringType().noDefaultValue().withDescription("redis hostname or ip");
    public static final Option<Integer> PORT = Options.key((String)"port").intType().defaultValue((Object)6379).withDescription("redis port");
    public static final Option<String> AUTH = Options.key((String)"auth").stringType().noDefaultValue().withDescription("redis authentication password, you need it when you connect to an encrypted cluster");
    public static final Option<Integer> DB_NUM = Options.key((String)"db_num").intType().defaultValue((Object)0).withDescription("Redis  database index id, it is connected to db 0 by default");
    public static final Option<String> USER = Options.key((String)"user").stringType().noDefaultValue().withDescription("redis authentication user, you need it when you connect to an encrypted cluster");
    public static final Option<String> KEY_PATTERN = Options.key((String)"keys").stringType().noDefaultValue().withDescription("keys pattern, redis source connector support fuzzy key matching, user needs to ensure that the matched keys are the same type");
    public static final Option<String> KEY = Options.key((String)"key").stringType().noDefaultValue().withDescription("The value of key you want to write to redis.");
    public static final Option<RedisDataType> DATA_TYPE = Options.key((String)"data_type").enumType(RedisDataType.class).noDefaultValue().withDescription("redis data types, support string hash list set zset.");
    public static final Option<Format> FORMAT = Options.key((String)"format").enumType(Format.class).defaultValue((Object)Format.JSON).withDescription("the format of upstream data, now only support json and text, default json.");
    public static final Option<RedisMode> MODE = Options.key((String)"mode").enumType(RedisMode.class).defaultValue((Object)RedisMode.SINGLE).withDescription("redis mode, support single or cluster, default value is single");
    public static final Option<List<String>> NODES = Options.key((String)"nodes").listType().noDefaultValue().withDescription("redis nodes information, used in cluster mode, must like as the following format: [host1:port1, host2:port2]");
    public static final Option<Integer> BATCH_SIZE = Options.key((String)"batch_size").intType().defaultValue((Object)10).withDescription("batch_size is used to control the size of a batch of data during read and write operations,default 10");

    public static enum Format {
        JSON;

    }

    public static enum RedisMode {
        SINGLE,
        CLUSTER;

    }
}

