/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClient;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClusterClient;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisSingleClient;
import org.apache.seatunnel.connectors.seatunnel.redis.config.JedisWrapper;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisConfig;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;
import org.apache.seatunnel.connectors.seatunnel.redis.exception.RedisConnectorException;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class RedisParameters
implements Serializable {
    private String host;
    private int port;
    private String auth = "";
    private int dbNum;
    private String user = "";
    private String keysPattern;
    private String keyField;
    private RedisDataType redisDataType;
    private RedisConfig.RedisMode mode;
    private RedisConfig.HashKeyParseMode hashKeyParseMode;
    private List<String> redisNodes = Collections.emptyList();
    private long expire = (Long)RedisConfig.EXPIRE.defaultValue();
    private int batchSize = (Integer)RedisConfig.BATCH_SIZE.defaultValue();

    public void buildWithConfig(ReadonlyConfig config) {
        this.host = (String)config.get(RedisConfig.HOST);
        this.port = (Integer)config.get(RedisConfig.PORT);
        this.dbNum = (Integer)config.get(RedisConfig.DB_NUM);
        this.hashKeyParseMode = (RedisConfig.HashKeyParseMode)((Object)config.get(RedisConfig.HASH_KEY_PARSE_MODE));
        this.expire = (Long)config.get(RedisConfig.EXPIRE);
        if (config.getOptional(RedisConfig.AUTH).isPresent()) {
            this.auth = (String)config.get(RedisConfig.AUTH);
        }
        if (config.getOptional(RedisConfig.USER).isPresent()) {
            this.user = (String)config.get(RedisConfig.USER);
        }
        this.mode = (RedisConfig.RedisMode)((Object)config.get(RedisConfig.MODE));
        if (config.getOptional(RedisConfig.NODES).isPresent()) {
            this.redisNodes = (List)config.get(RedisConfig.NODES);
        }
        if (config.getOptional(RedisConfig.KEY).isPresent()) {
            this.keyField = (String)config.get(RedisConfig.KEY);
        }
        if (config.getOptional(RedisConfig.KEY_PATTERN).isPresent()) {
            this.keysPattern = (String)config.get(RedisConfig.KEY_PATTERN);
        }
        this.redisDataType = (RedisDataType)((Object)config.get(RedisConfig.DATA_TYPE));
        this.batchSize = (Integer)config.get(RedisConfig.BATCH_SIZE);
    }

    public RedisClient buildRedisClient() {
        Jedis jedis = this.buildJedis();
        if (this.mode.equals((Object)RedisConfig.RedisMode.SINGLE)) {
            return new RedisSingleClient(this, jedis);
        }
        return new RedisClusterClient(this, jedis);
    }

    public Jedis buildJedis() {
        switch (this.mode) {
            case SINGLE: {
                Jedis jedis = new Jedis(this.host, this.port);
                if (StringUtils.isNotBlank((CharSequence)this.auth)) {
                    jedis.auth(this.auth);
                }
                if (StringUtils.isNotBlank((CharSequence)this.user)) {
                    jedis.aclSetUser(this.user);
                }
                jedis.select(this.dbNum);
                return jedis;
            }
            case CLUSTER: {
                HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
                HostAndPort node = new HostAndPort(this.host, this.port);
                nodes.add(node);
                if (!this.redisNodes.isEmpty()) {
                    for (String redisNode : this.redisNodes) {
                        String[] splits = redisNode.split(":");
                        if (splits.length != 2) {
                            throw new RedisConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Invalid redis node information,redis node information must like as the following: [host:port]");
                        }
                        HostAndPort hostAndPort = new HostAndPort(splits[0], Integer.parseInt(splits[1]));
                        nodes.add(hostAndPort);
                    }
                }
                ConnectionPoolConfig connectionPoolConfig = new ConnectionPoolConfig();
                JedisCluster jedisCluster = StringUtils.isNotBlank((CharSequence)this.auth) ? new JedisCluster(nodes, 2000, 2000, 5, this.auth, (GenericObjectPoolConfig<Connection>)connectionPoolConfig) : new JedisCluster(nodes);
                JedisWrapper jedisWrapper = new JedisWrapper(jedisCluster);
                jedisWrapper.select(this.dbNum);
                return jedisWrapper;
            }
        }
        throw new RedisConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Not support this redis mode");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuth() {
        return this.auth;
    }

    public int getDbNum() {
        return this.dbNum;
    }

    public String getUser() {
        return this.user;
    }

    public String getKeysPattern() {
        return this.keysPattern;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public RedisDataType getRedisDataType() {
        return this.redisDataType;
    }

    public RedisConfig.RedisMode getMode() {
        return this.mode;
    }

    public RedisConfig.HashKeyParseMode getHashKeyParseMode() {
        return this.hashKeyParseMode;
    }

    public List<String> getRedisNodes() {
        return this.redisNodes;
    }

    public long getExpire() {
        return this.expire;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public void setDbNum(int dbNum) {
        this.dbNum = dbNum;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setKeysPattern(String keysPattern) {
        this.keysPattern = keysPattern;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public void setRedisDataType(RedisDataType redisDataType) {
        this.redisDataType = redisDataType;
    }

    public void setMode(RedisConfig.RedisMode mode) {
        this.mode = mode;
    }

    public void setHashKeyParseMode(RedisConfig.HashKeyParseMode hashKeyParseMode) {
        this.hashKeyParseMode = hashKeyParseMode;
    }

    public void setRedisNodes(List<String> redisNodes) {
        this.redisNodes = redisNodes;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisParameters)) {
            return false;
        }
        RedisParameters other = (RedisParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getDbNum() != other.getDbNum()) {
            return false;
        }
        if (this.getExpire() != other.getExpire()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$keysPattern = this.getKeysPattern();
        String other$keysPattern = other.getKeysPattern();
        if (this$keysPattern == null ? other$keysPattern != null : !this$keysPattern.equals(other$keysPattern)) {
            return false;
        }
        String this$keyField = this.getKeyField();
        String other$keyField = other.getKeyField();
        if (this$keyField == null ? other$keyField != null : !this$keyField.equals(other$keyField)) {
            return false;
        }
        RedisDataType this$redisDataType = this.getRedisDataType();
        RedisDataType other$redisDataType = other.getRedisDataType();
        if (this$redisDataType == null ? other$redisDataType != null : !((Object)((Object)this$redisDataType)).equals((Object)other$redisDataType)) {
            return false;
        }
        RedisConfig.RedisMode this$mode = this.getMode();
        RedisConfig.RedisMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        RedisConfig.HashKeyParseMode this$hashKeyParseMode = this.getHashKeyParseMode();
        RedisConfig.HashKeyParseMode other$hashKeyParseMode = other.getHashKeyParseMode();
        if (this$hashKeyParseMode == null ? other$hashKeyParseMode != null : !((Object)((Object)this$hashKeyParseMode)).equals((Object)other$hashKeyParseMode)) {
            return false;
        }
        List<String> this$redisNodes = this.getRedisNodes();
        List<String> other$redisNodes = other.getRedisNodes();
        return !(this$redisNodes == null ? other$redisNodes != null : !((Object)this$redisNodes).equals(other$redisNodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getDbNum();
        long $expire = this.getExpire();
        result = result * 59 + (int)($expire >>> 32 ^ $expire);
        result = result * 59 + this.getBatchSize();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $keysPattern = this.getKeysPattern();
        result = result * 59 + ($keysPattern == null ? 43 : $keysPattern.hashCode());
        String $keyField = this.getKeyField();
        result = result * 59 + ($keyField == null ? 43 : $keyField.hashCode());
        RedisDataType $redisDataType = this.getRedisDataType();
        result = result * 59 + ($redisDataType == null ? 43 : ((Object)((Object)$redisDataType)).hashCode());
        RedisConfig.RedisMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        RedisConfig.HashKeyParseMode $hashKeyParseMode = this.getHashKeyParseMode();
        result = result * 59 + ($hashKeyParseMode == null ? 43 : ((Object)((Object)$hashKeyParseMode)).hashCode());
        List<String> $redisNodes = this.getRedisNodes();
        result = result * 59 + ($redisNodes == null ? 43 : ((Object)$redisNodes).hashCode());
        return result;
    }

    public String toString() {
        return "RedisParameters(host=" + this.getHost() + ", port=" + this.getPort() + ", auth=" + this.getAuth() + ", dbNum=" + this.getDbNum() + ", user=" + this.getUser() + ", keysPattern=" + this.getKeysPattern() + ", keyField=" + this.getKeyField() + ", redisDataType=" + (Object)((Object)this.getRedisDataType()) + ", mode=" + (Object)((Object)this.getMode()) + ", hashKeyParseMode=" + (Object)((Object)this.getHashKeyParseMode()) + ", redisNodes=" + this.getRedisNodes() + ", expire=" + this.getExpire() + ", batchSize=" + this.getBatchSize() + ")";
    }
}

