/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisConfig;
import org.apache.seatunnel.connectors.seatunnel.redis.source.RedisSource;

@AutoService(value={Factory.class})
public class RedisSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Redis";
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new RedisSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{RedisConfig.HOST, RedisConfig.PORT, RedisConfig.KEY_PATTERN, RedisConfig.DATA_TYPE}).optional(new Option[]{RedisConfig.MODE, RedisConfig.HASH_KEY_PARSE_MODE, RedisConfig.AUTH, RedisConfig.USER, RedisConfig.KEY}).conditional(RedisConfig.MODE, (Object)RedisConfig.RedisMode.CLUSTER, new Option[]{RedisConfig.NODES}).bundled(new Option[]{RedisConfig.FORMAT, TableSchemaOptions.SCHEMA}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return RedisSource.class;
    }
}

