/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.client;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public abstract class RedisClient
extends Jedis {
    protected final RedisParameters redisParameters;
    protected final int batchSize;
    protected final Jedis jedis;

    protected RedisClient(RedisParameters redisParameters, Jedis jedis) {
        this.redisParameters = redisParameters;
        this.batchSize = redisParameters.getBatchSize();
        this.jedis = jedis;
    }

    public ScanResult<String> scanKeys(String cursor, int batchSize, String keysPattern, RedisDataType type) {
        ScanParams scanParams = new ScanParams();
        scanParams.match(keysPattern);
        scanParams.count(batchSize);
        return this.jedis.scan(cursor, scanParams, type.name());
    }

    public abstract List<String> batchGetString(List<String> var1);

    public abstract List<List<String>> batchGetList(List<String> var1);

    public abstract List<Set<String>> batchGetSet(List<String> var1);

    public abstract List<Map<String, String>> batchGetHash(List<String> var1);

    public abstract List<List<String>> batchGetZset(List<String> var1);

    public abstract void batchWriteString(List<String> var1, List<String> var2, long var3);

    public abstract void batchWriteList(List<String> var1, List<String> var2, long var3);

    public abstract void batchWriteSet(List<String> var1, List<String> var2, long var3);

    public abstract void batchWriteHash(List<String> var1, List<String> var2, long var3);

    public abstract void batchWriteZset(List<String> var1, List<String> var2, long var3);
}

