/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpSpan;
import io.sentry.SentryLevel;
import io.sentry.SentryTraceHeader;
import io.sentry.Span;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Request;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryTracer
implements ITransaction {
    @NotNull
    private final SentryId eventId = new SentryId();
    @NotNull
    private final Span root;
    @NotNull
    private final List<Span> children = new CopyOnWriteArrayList<Span>();
    @NotNull
    private final IHub hub;
    @NotNull
    private final Contexts contexts = new Contexts();
    @Nullable
    private Request request;
    @NotNull
    private String name;

    public SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub) {
        Objects.requireNonNull(context, "context is required");
        Objects.requireNonNull(hub, "hub is required");
        this.root = new Span(context, this, hub);
        this.name = context.getName();
        this.hub = hub;
    }

    @NotNull
    public List<Span> getChildren() {
        return this.children;
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.root.getStartTimestamp();
    }

    @Nullable
    public Date getTimestamp() {
        return this.root.getTimestamp();
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description) {
        ISpan span = this.startChild(parentSpanId, operation);
        span.setDescription(description);
        return span;
    }

    @NotNull
    private ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation) {
        Objects.requireNonNull(parentSpanId, "parentSpanId is required");
        Objects.requireNonNull(operation, "operation is required");
        Span span = new Span(this.root.getTraceId(), parentSpanId, this, operation, this.hub);
        this.children.add(span);
        return span;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        if (this.children.size() < this.hub.getOptions().getMaxSpans()) {
            return this.root.startChild(operation, description);
        }
        this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Span operation: %s, description: %s dropped due to limit reached. Returning NoOpSpan.", operation, description);
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return this.root.toSentryTrace();
    }

    @Override
    public void finish() {
        this.finish(this.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        if (!this.root.isFinished()) {
            this.root.finish(status);
            this.hub.configureScope(scope -> scope.withTransaction(transaction -> {
                if (transaction == this) {
                    scope.clearTransaction();
                }
            }));
            SentryTransaction transaction = new SentryTransaction(this);
            this.hub.captureTransaction(transaction);
        }
    }

    @Override
    public void setOperation(@NotNull String operation) {
        this.root.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.root.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        this.root.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.root.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        this.root.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.root.getStatus();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        this.root.setThrowable(throwable);
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.root.getThrowable();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.root.getSpanContext();
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        this.root.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.root.getTag(key);
    }

    @Override
    public boolean isFinished() {
        return this.root.isFinished();
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return this.root.isSampled();
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public Request getRequest() {
        return this.request;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    @Override
    @NotNull
    public List<Span> getSpans() {
        return this.children;
    }

    @Override
    @Nullable
    public Span getLatestActiveSpan() {
        ArrayList<Span> spans = new ArrayList<Span>(this.children);
        if (!spans.isEmpty()) {
            for (int i = spans.size() - 1; i >= 0; --i) {
                if (((Span)spans.get(i)).isFinished()) continue;
                return (Span)spans.get(i);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SentryId getEventId() {
        return this.eventId;
    }

    @NotNull
    Span getRoot() {
        return this.root;
    }
}

