/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.slack.client;

import com.slack.api.Slack;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import com.slack.api.methods.response.conversations.ConversationsListResponse;
import com.slack.api.model.Conversation;
import java.io.IOException;
import java.util.List;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.connectors.seatunnel.slack.config.SlackConfig;
import org.apache.seatunnel.connectors.seatunnel.slack.exception.SlackConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.slack.exception.SlackConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackClient {
    private static final Logger log = LoggerFactory.getLogger(SlackClient.class);
    private final Config pluginConfig;
    private final MethodsClient methodsClient;

    public SlackClient(Config pluginConfig) {
        this.pluginConfig = pluginConfig;
        this.methodsClient = Slack.getInstance().methods();
    }

    public String findConversation() {
        String conversionId = "";
        try {
            ConversationsListResponse conversationsListResponse = this.methodsClient.conversationsList(r -> r.token(this.pluginConfig.getString(SlackConfig.OAUTH_TOKEN.key())));
            List<Conversation> channels = conversationsListResponse.getChannels();
            for (Conversation channel : channels) {
                if (!channel.getName().equals(this.pluginConfig.getString(SlackConfig.SLACK_CHANNEL.key()))) continue;
                conversionId = channel.getId();
                break;
            }
        }
        catch (SlackApiException | IOException e) {
            log.warn("Find Slack Conversion Fail.", (Throwable)e);
            throw new SlackConnectorException((SeaTunnelErrorCode)SlackConnectorErrorCode.FIND_SLACK_CONVERSATION_FAILED, e);
        }
        return conversionId;
    }

    public boolean publishMessage(String channelId, String text) {
        boolean publishMessageSuccess = false;
        try {
            ChatPostMessageResponse chatPostMessageResponse = this.methodsClient.chatPostMessage(r -> r.token(this.pluginConfig.getString(SlackConfig.SLACK_CHANNEL.key())).channel(channelId).text(text));
            publishMessageSuccess = chatPostMessageResponse.isOk();
        }
        catch (SlackApiException | IOException e) {
            log.error("error: {}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        return publishMessageSuccess;
    }

    public void closeMethodClient() {
    }
}

