/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.auth.CredentialsProvider;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.comm.ServiceClient;
import com.aliyun.openservices.log.util.Args;

public class ClientBuilder {
    private final String endpoint;
    private final CredentialsProvider credentialsProvider;
    private ClientConfiguration clientConfiguration;
    private ServiceClient serviceClient;
    private String sourceIp;

    public ClientBuilder(String endpoint, CredentialsProvider credentialsProvider) {
        this.endpoint = endpoint;
        this.credentialsProvider = credentialsProvider;
    }

    public ClientBuilder clientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this;
    }

    public ClientBuilder serviceClient(ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
        return this;
    }

    public ClientBuilder sourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
        return this;
    }

    public Client build() {
        Args.notNull(this.endpoint, "endpoint");
        Args.notNull(this.credentialsProvider, "credentialsProvider");
        if (this.clientConfiguration == null) {
            this.clientConfiguration = Client.getDefaultClientConfiguration();
        }
        if (this.serviceClient == null) {
            this.serviceClient = Client.buildServiceClient(this.clientConfiguration);
        }
        return new Client(this.endpoint, this.credentialsProvider, this.serviceClient, this.sourceIp);
    }
}

