/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ShipperMigration
implements Serializable {
    private String name = "";
    private String logstore = "";
    private String region = "";
    private String shipperName = "";
    private String shipperType = "";
    private String exportLink = "";
    private String state = "";
    private int retryCount = 0;
    private String message = "";
    private String userConf = "";
    private long createTime = 0L;
    private long updateTime = 0L;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getShipperType() {
        return this.shipperType;
    }

    public void setShipperType(String shipperType) {
        this.shipperType = shipperType;
    }

    public String getExportLink() {
        return this.exportLink;
    }

    public void setExportLink(String exportLink) {
        this.exportLink = exportLink;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUserConf() {
        return this.userConf;
    }

    public void setUserConf(String userConf) {
        this.userConf = userConf;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLogstore() {
        return this.logstore;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public String getShipperName() {
        return this.shipperName;
    }

    public void setShipperName(String shipperName) {
        this.shipperName = shipperName;
    }

    public ShipperMigration(String name, String logstore, String shipperName) {
        this.name = name;
        this.logstore = logstore;
        this.shipperName = shipperName;
    }

    public void checkForCreate() throws IllegalArgumentException {
        this.checkStringEmpty("name", this.name);
        this.checkStringEmpty("logstore", this.logstore);
        this.checkStringEmpty("shipperName", this.shipperName);
    }

    public String ToCreateJsonString() throws LogException {
        JSONObject result = new JSONObject();
        result.put("name", (Object)this.getName());
        result.put("logstore", (Object)this.getLogstore());
        result.put("shipperName", (Object)this.getShipperName());
        return result.toJSONString();
    }

    private void checkStringEmpty(String name, String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(name + " is null/empty");
        }
    }

    public static ShipperMigration extractGetMigration(JSONObject body, String requestId) throws LogException {
        ShipperMigration migration = new ShipperMigration("", "", "");
        migration.setName(body.getString("name"));
        migration.setLogstore(body.getString("logstore"));
        migration.setShipperName(body.getString("shipperName"));
        migration.setShipperType(body.getString("shipperType"));
        migration.setExportLink(body.getString("exportLink"));
        migration.setState(body.getString("state"));
        migration.setRetryCount(body.getInteger("retryCount"));
        migration.setMessage(body.getString("message"));
        migration.setUserConf(body.getString("userConf"));
        migration.setCreateTime(body.getLong("createTime"));
        migration.setUpdateTime(body.getLong("updateTime"));
        return migration;
    }

    public static ShipperMigration extractListMigration(JSONObject body, String requestId) throws LogException {
        ShipperMigration migration = new ShipperMigration("", "", "");
        migration.setName(body.getString("name"));
        migration.setLogstore(body.getString("logstore"));
        migration.setShipperName(body.getString("shipperName"));
        migration.setShipperType(body.getString("shipperType"));
        migration.setExportLink(body.getString("exportLink"));
        migration.setState(body.getString("state"));
        migration.setMessage(body.getString("message"));
        return migration;
    }

    public static List<ShipperMigration> extractMigrations(JSONObject body, String requestId) throws LogException {
        ArrayList<ShipperMigration> migrations = new ArrayList<ShipperMigration>();
        JSONArray array = new JSONArray();
        try {
            array = body.getJSONArray("migrations");
            if (array == null) {
                return migrations;
            }
            for (int index = 0; index < array.size(); ++index) {
                JSONObject jsonObject = array.getJSONObject(index);
                if (jsonObject == null) continue;
                migrations.add(ShipperMigration.extractListMigration(jsonObject, requestId));
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return migrations;
    }
}

