/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.signer;

import com.aliyun.openservices.log.common.auth.CredentialsProvider;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.signer.SignVersion;
import com.aliyun.openservices.log.http.signer.SlsSigner;
import com.aliyun.openservices.log.http.signer.SlsV1Signer;
import com.aliyun.openservices.log.http.signer.SlsV4Signer;
import java.util.Map;

public abstract class SlsSignerBase {
    protected CredentialsProvider credentialsProvider;

    public SlsSignerBase(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public static SlsSigner createRequestSigner(ClientConfiguration clientConfiguration, CredentialsProvider credentialsProvider) {
        if (clientConfiguration.getSignatureVersion() == SignVersion.V4) {
            return new SlsV4Signer(credentialsProvider, clientConfiguration.getRegion());
        }
        return new SlsV1Signer(credentialsProvider);
    }

    protected void addHeaderSecurityToken(String securityToken, Map<String, String> headers) {
        if (securityToken != null && !securityToken.isEmpty()) {
            headers.put("x-acs-security-token", securityToken);
        }
    }
}

