/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.signer;

import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.common.auth.CredentialsProvider;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.signer.SlsSigner;
import com.aliyun.openservices.log.http.signer.SlsSignerBase;
import com.aliyun.openservices.log.http.utils.DateUtil;
import com.aliyun.openservices.log.util.Utils;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SlsV1Signer
extends SlsSignerBase
implements SlsSigner {
    public SlsV1Signer(CredentialsProvider credentialsProvider) {
        super(credentialsProvider);
    }

    public static String md5Crypt(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String res = new BigInteger(1, md.digest(bytes)).toString(16).toUpperCase();
            StringBuilder zeros = new StringBuilder();
            int i = 0;
            while (i + res.length() < 32) {
                zeros.append("0");
                ++i;
            }
            return zeros + res;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not Supported signature method MD5", e);
        }
    }

    @Override
    public void sign(HttpMethod httpMethod, Map<String, String> headers, String resourceUri, Map<String, String> urlParams, byte[] body) {
        String contendMD5;
        Credentials credentials = this.credentialsProvider.getCredentials();
        this.addHeaderSecurityToken(credentials.getSecurityToken(), headers);
        if (body != null && body.length > 0) {
            contendMD5 = SlsV1Signer.md5Crypt(body);
            headers.put("Content-MD5", contendMD5);
            headers.put("Content-Length", String.valueOf(body.length));
        } else {
            contendMD5 = "";
            headers.put("Content-Length", "0");
        }
        String dateGMT = DateUtil.formatRfc822Date(new Date());
        headers.put("Date", dateGMT);
        headers.put("x-log-signaturemethod", "hmac-sha1");
        StringBuilder builder = new StringBuilder();
        builder.append(httpMethod.toString()).append("\n");
        builder.append(contendMD5).append("\n");
        builder.append(Utils.getOrEmpty(headers, "Content-Type")).append("\n");
        builder.append(dateGMT).append("\n");
        builder.append(SlsV1Signer.headersToString(headers)).append("\n");
        builder.append(resourceUri);
        if (!urlParams.isEmpty()) {
            builder.append("?");
            builder.append(SlsV1Signer.urlParametersToString(urlParams));
        }
        String signature = SlsV1Signer.encode(credentials.getAccessKeySecret(), builder.toString());
        headers.put("Authorization", "LOG " + credentials.getAccessKeyId() + ":" + signature);
    }

    static String urlParametersToString(Map<String, String> paras) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(paras);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private static String headersToString(Map<String, String> headers) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(headers);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-log-") && !((String)entry.getKey()).startsWith("x-acs-")) continue;
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append((String)entry.getKey()).append(":").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private static String encode(String accessKey, String data) {
        try {
            byte[] keyBytes = accessKey.getBytes("UTF-8");
            byte[] dataBytes = data.getBytes("UTF-8");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(keyBytes, "HmacSHA1"));
            return new String(Base64.encodeBase64(mac.doFinal(dataBytes)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not supported encoding method UTF-8", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not supported signature method hmac-sha1", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to calculate the signature", e);
        }
    }
}

