/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.request;

import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.LogGroup;
import com.aliyun.openservices.log.common.Logs;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.request.Request;
import com.aliyun.openservices.log.util.Utils;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class BatchPutLogsRequest
extends Request {
    private static final long serialVersionUID = 3221252831212912821L;
    private final List<LogGroup> mLogGroups = new ArrayList<LogGroup>();
    private String mLogStore;
    private String mHashKey;
    private Consts.CompressType mCompressType = Consts.CompressType.LZ4;

    public BatchPutLogsRequest(String project, String logStore, List<LogGroup> logGroups, String hashKey) {
        super(project);
        this.mLogStore = logStore;
        this.mHashKey = hashKey;
        this.mLogGroups.addAll(logGroups);
    }

    public String getLogStore() {
        return this.mLogStore;
    }

    public void setLogStore(String logStore) {
        this.mLogStore = logStore;
    }

    public String getHashKey() {
        return this.mHashKey;
    }

    public void setHashKey(String hashKey) {
        this.mHashKey = hashKey;
    }

    public List<LogGroup> getLogGroups() {
        return this.mLogGroups;
    }

    public void setLogGroups(List<LogGroup> logGroups) {
        this.mLogGroups.clear();
        this.mLogGroups.addAll(logGroups);
    }

    public Consts.CompressType getCompressType() {
        return this.mCompressType;
    }

    public void setCompressType(Consts.CompressType compressType) {
        this.mCompressType = compressType;
    }

    public byte[] serializeToPb() throws LogException {
        Logs.SlsCompressType compressType = Logs.SlsCompressType.SLS_CMP_NONE;
        switch (this.getCompressType()) {
            case LZ4: {
                compressType = Logs.SlsCompressType.SLS_CMP_LZ4;
                break;
            }
            case ZSTD: {
                compressType = Logs.SlsCompressType.SLS_CMP_ZSTD;
                break;
            }
            case GZIP: {
                compressType = Logs.SlsCompressType.SLS_CMP_DEFLATE;
                break;
            }
        }
        Logs.SlsLogPackageList.Builder builder = Logs.SlsLogPackageList.newBuilder();
        for (LogGroup logGroup : this.mLogGroups) {
            byte[] logGroupBytes = logGroup.serializeToPb();
            Logs.SlsLogPackage.Builder packageBuilder = builder.addPackagesBuilder();
            packageBuilder.setUncompressSize(logGroupBytes.length);
            packageBuilder.setCompressType(compressType);
            packageBuilder.setData(ByteString.copyFrom(Utils.compressLogBytes(logGroupBytes, this.getCompressType())));
        }
        return builder.build().toByteArray();
    }
}

