/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sls.serialization;

import com.aliyun.openservices.log.common.FastLog;
import com.aliyun.openservices.log.common.FastLogGroup;
import com.aliyun.openservices.log.common.LogGroupData;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.sls.serialization.FastLogDeserialization;

public class FastLogDeserializationContent
implements DeserializationSchema<SeaTunnelRow>,
FastLogDeserialization<SeaTunnelRow> {
    public static final DateTimeFormatter TIME_FORMAT = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private final CatalogTable catalogTable;

    public FastLogDeserializationContent(CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
    }

    public SeaTunnelRow deserialize(byte[] bytes) throws IOException {
        return null;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return null;
    }

    @Override
    public void deserialize(List<LogGroupData> logGroupDatas, Collector<SeaTunnelRow> out) throws IOException {
        for (LogGroupData logGroupData : logGroupDatas) {
            FastLogGroup logs = logGroupData.GetFastLogGroup();
            for (FastLog log : logs.getLogs()) {
                SeaTunnelRow seaTunnelRow = this.convertFastLogContent(log);
                out.collect((Object)seaTunnelRow);
            }
        }
    }

    private SeaTunnelRow convertFastLogContent(FastLog log) {
        SeaTunnelRowType rowType = this.catalogTable.getSeaTunnelRowType();
        ArrayList<String> transformedRow = new ArrayList<String>(rowType.getTotalFields());
        StringBuilder jsonStringBuilder = new StringBuilder();
        jsonStringBuilder.append("{");
        log.getContents().forEach(content -> jsonStringBuilder.append("\"").append(content.getKey()).append("\":\"").append(content.getValue()).append("\","));
        jsonStringBuilder.deleteCharAt(jsonStringBuilder.length() - 1);
        jsonStringBuilder.append("}");
        transformedRow.add(jsonStringBuilder.toString());
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(transformedRow.toArray());
        seaTunnelRow.setRowKind(RowKind.INSERT);
        seaTunnelRow.setTableId(this.catalogTable.getTableId().getTableName());
        return seaTunnelRow;
    }
}

