/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;

public class CnameConfiguration {
    private String domain;
    private CnameStatus status = CnameStatus.Unknown;
    private long lastModifiedTime;
    private Certificate certificate;

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CnameStatus getStatus() {
        return this.status;
    }

    public void setStatus(CnameStatus status) {
        this.status = status;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public String toString() {
        return "CnameConfiguration{domain='" + this.domain + '\'' + ", status=" + (Object)((Object)this.status) + ", lastModifiedTime=" + this.lastModifiedTime + ", certificate=" + this.certificate + '}';
    }

    public void unmarshal(JSONObject unmarshalled) {
        this.domain = unmarshalled.getString("domain");
        this.lastModifiedTime = unmarshalled.getLongValue("lastModified");
        this.status = CnameStatus.parse(unmarshalled.getString("status"));
        JSONObject cert = unmarshalled.getJSONObject("certificate");
        if (cert != null) {
            this.certificate = new Certificate();
            this.certificate.unmarshal(cert);
        }
    }

    public static class Certificate {
        private CertType type;
        private String certId;
        private CertStatus status;
        private String creationDate;
        private String fingerprint;
        private String validStartDate;
        private String validEndDate;

        public CertType getType() {
            return this.type;
        }

        public void setType(CertType type) {
            this.type = type;
        }

        public String getCertId() {
            return this.certId;
        }

        public void setCertId(String certId) {
            this.certId = certId;
        }

        public CertStatus getStatus() {
            return this.status;
        }

        public void setStatus(CertStatus status) {
            this.status = status;
        }

        public String getCreationDate() {
            return this.creationDate;
        }

        public void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        public String getValidStartDate() {
            return this.validStartDate;
        }

        public void setValidStartDate(String validStartDate) {
            this.validStartDate = validStartDate;
        }

        public String getValidEndDate() {
            return this.validEndDate;
        }

        public void setValidEndDate(String validEndDate) {
            this.validEndDate = validEndDate;
        }

        public String toString() {
            return "Certificate{type=" + (Object)((Object)this.type) + ", certId='" + this.certId + '\'' + ", status=" + (Object)((Object)this.status) + ", creationDate='" + this.creationDate + '\'' + ", fingerprint='" + this.fingerprint + '\'' + ", validStartDate='" + this.validStartDate + '\'' + ", validEndDate='" + this.validEndDate + '\'' + '}';
        }

        public void unmarshal(JSONObject unmarshalled) {
            this.type = CertType.parse(unmarshalled.getString("type"));
            this.certId = unmarshalled.getString("certId");
            this.status = CertStatus.parse(unmarshalled.getString("status"));
            this.creationDate = unmarshalled.getString("creationDate");
            this.fingerprint = unmarshalled.getString("fingerprint");
            this.validStartDate = unmarshalled.getString("validStartDate");
            this.validEndDate = unmarshalled.getString("validEndDate");
        }
    }

    public static enum CertType {
        Unknown("Unknown"),
        CAS("CAS"),
        Upload("Upload");

        private final String certTypeString;

        private CertType(String certTypeString) {
            this.certTypeString = certTypeString;
        }

        public String toString() {
            return this.certTypeString;
        }

        public static CertType parse(String certTypeString) {
            for (CertType ct : CertType.values()) {
                if (!ct.toString().equalsIgnoreCase(certTypeString)) continue;
                return ct;
            }
            throw new IllegalArgumentException("Unable to parse " + certTypeString);
        }
    }

    public static enum CertStatus {
        Unknown("Unknown"),
        Enabled("Enabled"),
        Disabled("Disabled"),
        Blocked("Blocked"),
        Forbidden("Forbidden");

        private final String certStatusString;

        private CertStatus(String certStatusString) {
            this.certStatusString = certStatusString;
        }

        public String toString() {
            return this.certStatusString;
        }

        public static CertStatus parse(String certStatusString) {
            for (CertStatus st : CertStatus.values()) {
                if (!st.toString().equalsIgnoreCase(certStatusString)) continue;
                return st;
            }
            throw new IllegalArgumentException("Unable to parse " + certStatusString);
        }
    }

    public static enum CnameStatus {
        Unknown("Unknown"),
        Enabled("Enabled"),
        Disabled("Disabled"),
        Blocked("Blocked"),
        Forbidden("Forbidden");

        private final String cnameStatusString;

        private CnameStatus(String cnameStatusString) {
            this.cnameStatusString = cnameStatusString;
        }

        public String toString() {
            return this.cnameStatusString;
        }

        public static CnameStatus parse(String cnameStatusString) {
            for (CnameStatus st : CnameStatus.values()) {
                if (!st.toString().equalsIgnoreCase(cnameStatusString)) continue;
                return st;
            }
            throw new IllegalArgumentException("Unable to parse " + cnameStatusString);
        }
    }
}

