/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.Chart;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;

public class Dashboard
implements Serializable {
    private static final long serialVersionUID = 3152635375534266524L;
    private String dashboardName = "";
    private String description = "";
    private String displayName = "";
    private String attribute = "";
    private ArrayList<Chart> chartList = new ArrayList();

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDashboardName() {
        return this.dashboardName;
    }

    public void setDashboardName(String dashboardName) {
        this.dashboardName = dashboardName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<Chart> getChartList() {
        return this.chartList;
    }

    public void setChartList(ArrayList<Chart> chartList) {
        this.chartList = new ArrayList();
        for (Chart chart : chartList) {
            this.chartList.add(chart);
        }
    }

    public Dashboard() {
    }

    public Dashboard(String dashboardName, String description, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
    }

    public Dashboard(String dashboardName, String displayName, String description, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
        this.displayName = displayName;
    }

    public Dashboard(String dashboardName, String displayName, String description, String attribute, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
        this.displayName = displayName;
        this.attribute = attribute;
    }

    public JSONObject ToJsonObject() {
        JSONObject dashboardJson = new JSONObject();
        dashboardJson.put("dashboardName", (Object)this.getDashboardName());
        dashboardJson.put("description", (Object)this.getDescription());
        dashboardJson.put("displayName", (Object)this.getDisplayName());
        if (this.getAttribute().length() > 0) {
            dashboardJson.put("attribute", (Object)JSONObject.parseObject(this.getAttribute()));
        } else {
            dashboardJson.put("attribute", (Object)JSONObject.parseObject("{}"));
        }
        JSONArray chartArray = new JSONArray();
        for (Chart chart : this.getChartList()) {
            chartArray.add(chart.ToJsonObject());
        }
        dashboardJson.put("charts", (Object)chartArray);
        return dashboardJson;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.setDashboardName(dict.getString("dashboardName"));
            this.setDescription(dict.getString("description"));
            if (dict.containsKey("displayName")) {
                this.setDisplayName(dict.getString("displayName"));
            }
            if (dict.containsKey("attribute")) {
                JSONObject attributeJson = dict.getJSONObject("attribute");
                this.setAttribute(attributeJson.toString());
            }
            ArrayList<Chart> chartList = new ArrayList<Chart>();
            try {
                JSONArray chartJsonArray = dict.getJSONArray("charts");
                if (chartJsonArray != null) {
                    for (int index = 0; index != chartJsonArray.size(); ++index) {
                        JSONObject jsonObject = chartJsonArray.getJSONObject(index);
                        if (jsonObject == null) continue;
                        Chart chart = new Chart();
                        chart.FromJsonObject(jsonObject);
                        chartList.add(chart);
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.setChartList(chartList);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateDashboard", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String dashboardString) throws LogException {
        try {
            JSONObject dict = JSONObject.parseObject(dashboardString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateDashboard", e.getMessage(), e, "");
        }
    }
}

