/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.Logs;
import com.aliyun.openservices.log.common.TagContent;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.utils.CodingUtils;
import com.aliyun.openservices.log.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LogGroup
implements Serializable {
    private static final long serialVersionUID = -1238325851112921953L;
    private final List<LogItem> mLogItems = new ArrayList<LogItem>();
    private String mTopic = "";
    private String mSource = "";
    protected String mMachineUUID = "";
    private final List<TagContent> mLogTags = new ArrayList<TagContent>();

    public LogGroup() {
    }

    public LogGroup(List<LogItem> items) {
        this.mLogItems.addAll(items);
    }

    public LogGroup(List<LogItem> items, List<TagContent> tags, String topic, String source) {
        this.mLogItems.addAll(items);
        this.mLogTags.addAll(tags);
        this.mTopic = topic;
        this.mSource = source;
    }

    public List<LogItem> getLogItems() {
        return this.mLogItems;
    }

    public String getTopic() {
        return this.mTopic;
    }

    public void setTopic(String mTopic) {
        this.mTopic = mTopic;
    }

    public String getSource() {
        return this.mSource;
    }

    public void setSource(String mSource) {
        this.mSource = mSource;
    }

    public String getMachineUUID() {
        return this.mMachineUUID;
    }

    public void setMachineUUID(String mMachineUUID) {
        this.mMachineUUID = mMachineUUID;
    }

    public List<TagContent> getLogTags() {
        return this.mLogTags;
    }

    public byte[] serializeToPb() throws LogException {
        List<TagContent> tags;
        String uuid;
        String source;
        Logs.LogGroup.Builder builder = Logs.LogGroup.newBuilder();
        String topic = this.getTopic();
        if (!Utils.isBlank(topic)) {
            builder.setTopic(topic);
        }
        if (!Utils.isBlank(source = this.getSource())) {
            builder.setSource(source);
        }
        if (!Utils.isBlank(uuid = this.getMachineUUID())) {
            builder.setMachineUUID(uuid);
        }
        if ((tags = this.getLogTags()) != null && tags.size() > 0) {
            for (TagContent tag : tags) {
                Logs.LogTag.Builder tagBuilder = builder.addLogTagsBuilder();
                tagBuilder.setKey(tag.getKey());
                tagBuilder.setValue(tag.getValue());
            }
        }
        List<LogItem> logs = this.getLogItems();
        for (LogItem item : logs) {
            Logs.Log.Builder log = builder.addLogsBuilder();
            log.setTime(item.mLogTime);
            if (item.mLogTimeNsPart != 0) {
                log.setTimeNs(item.mLogTimeNsPart);
            }
            for (LogContent content : item.mContents) {
                CodingUtils.assertStringNotNullOrEmpty(content.mKey, "key");
                Logs.Log.Content.Builder contentBuilder = log.addContentsBuilder();
                contentBuilder.setKey(content.mKey);
                if (content.mValue == null) {
                    contentBuilder.setValue("");
                    continue;
                }
                contentBuilder.setValue(content.mValue);
            }
        }
        return builder.build().toByteArray();
    }
}

