/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.sample;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.OdpsShipperConfig;
import com.aliyun.openservices.log.common.OssShipperConfig;
import com.aliyun.openservices.log.common.OssShipperCsvStorageDetail;
import com.aliyun.openservices.log.common.OssShipperJsonStorageDetail;
import com.aliyun.openservices.log.common.OssShipperParquetStorageDetail;
import com.aliyun.openservices.log.common.OssShipperStorageColumn;
import com.aliyun.openservices.log.common.ShipperTask;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.GetShipperResponse;
import com.aliyun.openservices.log.response.GetShipperTasksResponse;
import java.util.ArrayList;

public class ShipperSample {
    private static final String accessKeyId = "";
    private static final String accessKeySecret = "";
    private static final String host = "cn-shanghai-staging.sls.aliyuncs.com";
    private static final String project = "project-for-test-1";
    private static final String logStore = "access_log";
    private static final Client client = new Client("cn-shanghai-staging.sls.aliyuncs.com", "", "");
    private static final String ossBucket = "sls-test-oss-shipper";
    private static final String ossPrefix = "logtailalarm";
    private static final String roleArn = "acs:ram::1654218965343050:role/aliyunlogdefaultrole";
    private static final String compressType = "none";
    private static final String pathFormat = "%Y/%m/%d/%H";
    private static final int bufferInterval = 300;
    private static final int bufferSize = 10;

    public static void createOdpsShipper() throws LogException {
        String shipperName = "odpsshipper";
        String odpsEndPoint = "";
        String odpsProject = "odps_project";
        String odpsTable = "odps_table";
        ArrayList<String> logFieldsList = new ArrayList<String>();
        logFieldsList.add("__topic__");
        logFieldsList.add("__time__");
        logFieldsList.add("a");
        logFieldsList.add("b");
        logFieldsList.add("b");
        ArrayList<String> partitionColumn = new ArrayList<String>();
        partitionColumn.add("p_a");
        partitionColumn.add("__PARTITION_TIME__");
        String partitionTimeFormat = "yyyy_MM_dd_HH_mm";
        OdpsShipperConfig shipConfig = new OdpsShipperConfig(odpsEndPoint, odpsProject, odpsTable, logFieldsList, partitionColumn, partitionTimeFormat);
        client.CreateShipper(project, logStore, shipperName, shipConfig);
        GetShipperResponse res = client.GetShipperConfig(project, logStore, shipperName);
        System.out.println(res.GetConfig().GetShipperType());
        System.out.println(res.GetConfig().GetJsonObj());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int startTime = (int)((double)System.currentTimeMillis() / 1000.0 - 7200.0);
        int endTime = (int)((double)System.currentTimeMillis() / 1000.0);
        GetShipperTasksResponse taskRes = client.GetShipperTasks(project, logStore, shipperName, startTime, endTime, "", 0, 10);
        System.out.println(taskRes.GetTotalTask());
        for (ShipperTask shipperTask : taskRes.GetShipperTasks()) {
            System.out.println(shipperTask.GetTaskCreateTime());
            System.out.println(shipperTask.GetTaskFinishTime());
            System.out.println(shipperTask.GetTaskDataLines());
        }
        client.DeleteShipper(project, logStore, shipperName);
    }

    public static void createJsonOssShipper() throws LogException {
        String shipperName = "ossjsonshipper";
        OssShipperConfig ossConfig = new OssShipperConfig(ossBucket, ossPrefix, roleArn, 300, 10, compressType, pathFormat, "json", "");
        OssShipperJsonStorageDetail detail = (OssShipperJsonStorageDetail)ossConfig.GetStorageDetail();
        detail.setEnableTag(false);
        client.CreateShipper(project, logStore, shipperName, ossConfig);
        GetShipperResponse ossRes = client.GetShipperConfig(project, logStore, shipperName);
        System.out.println(ossRes.GetConfig().GetShipperType());
        System.out.println(ossRes.GetConfig().GetJsonObj());
        client.DeleteShipper(project, logStore, shipperName);
    }

    public static void createParquetOssShipper() throws LogException {
        String shipperName = "ossparquetshipper";
        OssShipperConfig ossConfig = new OssShipperConfig(ossBucket, ossPrefix, roleArn, 300, 10, compressType, pathFormat, "parquet", "+1000");
        ArrayList<OssShipperStorageColumn> columns = new ArrayList<OssShipperStorageColumn>();
        columns.add(new OssShipperStorageColumn("MachineName", "string"));
        columns.add(new OssShipperStorageColumn("Role", "string"));
        columns.add(new OssShipperStorageColumn("ResValue", "int32"));
        columns.add(new OssShipperStorageColumn("__LINE__", "int64"));
        columns.add(new OssShipperStorageColumn("__THREAD__", "double"));
        OssShipperParquetStorageDetail detail = (OssShipperParquetStorageDetail)ossConfig.GetStorageDetail();
        detail.setStorageColumns(columns);
        client.CreateShipper(project, logStore, shipperName, ossConfig);
        GetShipperResponse ossRes = client.GetShipperConfig(project, logStore, shipperName);
        System.out.println(ossRes.GetConfig().GetShipperType());
        System.out.println(ossRes.GetConfig().GetJsonObj());
        client.DeleteShipper(project, logStore, shipperName);
    }

    public static void createCsvOssShipper() throws LogException {
        String shipperName = "osscsvshipper";
        OssShipperConfig ossConfig = new OssShipperConfig(ossBucket, ossPrefix, roleArn, 300, 10, compressType, pathFormat, "csv", "+0800");
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("__topic__");
        columns.add("alarm_count");
        columns.add("alarm_message");
        columns.add("alarm_type");
        columns.add("category");
        columns.add("project_name");
        OssShipperCsvStorageDetail detail = (OssShipperCsvStorageDetail)ossConfig.GetStorageDetail();
        detail.setDelimiter(",");
        detail.setmStorageColumns(columns);
        detail.setQuote("\"");
        detail.setNullIdentifier("");
        detail.setHeader(false);
        client.CreateShipper(project, logStore, shipperName, ossConfig);
        GetShipperResponse ossRes = client.GetShipperConfig(project, logStore, shipperName);
        System.out.println(ossRes.GetConfig().GetShipperType());
        System.out.println(ossRes.GetConfig().GetJsonObj());
        client.DeleteShipper(project, logStore, shipperName);
    }

    public static void main(String[] args) throws LogException {
        ShipperSample.createOdpsShipper();
        ShipperSample.createJsonOssShipper();
        ShipperSample.createCsvOssShipper();
        ShipperSample.createParquetOssShipper();
    }
}

