/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sls.serialization;

import com.aliyun.openservices.log.common.FastLog;
import com.aliyun.openservices.log.common.FastLogContent;
import com.aliyun.openservices.log.common.FastLogGroup;
import com.aliyun.openservices.log.common.LogGroupData;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.sls.serialization.FastLogDeserialization;
import org.apache.seatunnel.format.text.exception.SeaTunnelTextFormatException;

public class FastLogDeserializationSchema
implements DeserializationSchema<SeaTunnelRow>,
FastLogDeserialization<SeaTunnelRow> {
    public static final DateTimeFormatter TIME_FORMAT = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private final CatalogTable catalogTable;

    public FastLogDeserializationSchema(CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
    }

    public SeaTunnelRow deserialize(byte[] bytes) throws IOException {
        return null;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return null;
    }

    @Override
    public void deserialize(List<LogGroupData> logGroupDatas, Collector<SeaTunnelRow> out) throws IOException {
        for (LogGroupData logGroupData : logGroupDatas) {
            FastLogGroup logs = logGroupData.GetFastLogGroup();
            for (FastLog log : logs.getLogs()) {
                SeaTunnelRow seaTunnelRow = this.convertFastLogSchema(log);
                out.collect((Object)seaTunnelRow);
            }
        }
    }

    private SeaTunnelRow convertFastLogSchema(FastLog log) {
        SeaTunnelRowType rowType = this.catalogTable.getSeaTunnelRowType();
        ArrayList<Object> transformedRow = new ArrayList<Object>(rowType.getTotalFields());
        List<FastLogContent> logContents = log.getContents();
        for (FastLogContent flc : logContents) {
            int keyIndex = rowType.indexOf(flc.getKey(), false);
            if (keyIndex <= -1) continue;
            Object field = this.convert(rowType.getFieldType(keyIndex), flc.getValue());
            transformedRow.add(keyIndex, field);
        }
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(transformedRow.toArray());
        seaTunnelRow.setRowKind(RowKind.INSERT);
        seaTunnelRow.setTableId(this.catalogTable.getTableId().getTableName());
        return seaTunnelRow;
    }

    private Object convert(SeaTunnelDataType<?> fieldType, String field) throws SeaTunnelTextFormatException {
        switch (fieldType.getSqlType()) {
            case STRING: {
                return field;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(field);
            }
            case TINYINT: {
                return Byte.parseByte(field);
            }
            case SMALLINT: {
                return Short.parseShort(field);
            }
            case INT: {
                return Integer.parseInt(field);
            }
            case BIGINT: {
                return Long.parseLong(field);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(field));
            }
            case DOUBLE: {
                return Double.parseDouble(field);
            }
            case DECIMAL: {
                return new BigDecimal(field);
            }
            case NULL: {
                return null;
            }
            case BYTES: {
                return field.getBytes(StandardCharsets.UTF_8);
            }
        }
        throw new SeaTunnelTextFormatException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel not support this data type [%s]", fieldType.getSqlType()));
    }
}

