/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.sls.source;

import com.aliyun.openservices.log.common.Consts;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.ReadonlyConfigParser;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.sls.config.SlsSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.sls.config.StartMode;
import org.apache.seatunnel.connectors.seatunnel.sls.serialization.FastLogDeserialization;
import org.apache.seatunnel.connectors.seatunnel.sls.serialization.FastLogDeserializationContent;
import org.apache.seatunnel.connectors.seatunnel.sls.serialization.FastLogDeserializationSchema;
import org.apache.seatunnel.connectors.seatunnel.sls.source.ConsumerMetaData;
import org.apache.seatunnel.format.text.TextDeserializationSchema;

public class SlsSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final String accessKeyId;
    private final String accessKeySecret;
    private final Long discoveryIntervalMillis;
    private final CatalogTable catalogTable;
    private final ConsumerMetaData consumerMetaData;

    public SlsSourceConfig(ReadonlyConfig readonlyConfig) {
        this.endpoint = (String)readonlyConfig.get(SlsSourceOptions.ENDPOINT);
        this.accessKeyId = (String)readonlyConfig.get(SlsSourceOptions.ACCESS_KEY_ID);
        this.accessKeySecret = (String)readonlyConfig.get(SlsSourceOptions.ACCESS_KEY_SECRET);
        this.discoveryIntervalMillis = (Long)readonlyConfig.get(SlsSourceOptions.KEY_PARTITION_DISCOVERY_INTERVAL_MILLIS);
        this.catalogTable = this.createCatalogTable(readonlyConfig);
        this.consumerMetaData = this.createMetaData(readonlyConfig);
    }

    public ConsumerMetaData createMetaData(ReadonlyConfig readonlyConfig) {
        ConsumerMetaData consumerMetaData = new ConsumerMetaData();
        consumerMetaData.setProject((String)readonlyConfig.get(SlsSourceOptions.PROJECT));
        consumerMetaData.setLogstore((String)readonlyConfig.get(SlsSourceOptions.LOGSTORE));
        consumerMetaData.setConsumerGroup((String)readonlyConfig.get(SlsSourceOptions.CONSUMER_GROUP));
        consumerMetaData.setStartMode((StartMode)((Object)readonlyConfig.get(SlsSourceOptions.START_MODE)));
        consumerMetaData.setFetchSize((Integer)readonlyConfig.get(SlsSourceOptions.BATCH_SIZE));
        consumerMetaData.setAutoCursorReset((Consts.CursorMode)((Object)readonlyConfig.get(SlsSourceOptions.AUTO_CURSOR_RESET)));
        consumerMetaData.setDeserializationSchema(this.createDeserializationSchema(readonlyConfig));
        consumerMetaData.setCatalogTable(this.catalogTable);
        return consumerMetaData;
    }

    private CatalogTable createCatalogTable(ReadonlyConfig readonlyConfig) {
        Optional schemaOptions = readonlyConfig.getOptional(ConnectorCommonOptions.SCHEMA);
        TablePath tablePath = TablePath.of((String)((String)readonlyConfig.get(SlsSourceOptions.LOGSTORE)));
        TableSchema tableSchema = schemaOptions.isPresent() ? new ReadonlyConfigParser().parse(readonlyConfig) : TableSchema.builder().column((Column)PhysicalColumn.of((String)"content", (SeaTunnelDataType)BasicType.STRING_TYPE, (Integer)0, (boolean)false, (Object)"{}", null)).build();
        return CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"", (TablePath)tablePath), (TableSchema)tableSchema, Collections.emptyMap(), Collections.emptyList(), null);
    }

    private FastLogDeserialization<SeaTunnelRow> createDeserializationSchema(ReadonlyConfig readonlyConfig) {
        Optional schemaOptions = readonlyConfig.getOptional(ConnectorCommonOptions.SCHEMA);
        DeserializationSchema<SeaTunnelRow> fastLogDeserialization = schemaOptions.isPresent() ? new FastLogDeserializationSchema(this.catalogTable) : new FastLogDeserializationContent(this.catalogTable);
        return fastLogDeserialization;
    }

    private DeserializationSchema<SeaTunnelRow> createDeserializationSchema(CatalogTable catalogTable) {
        SeaTunnelRowType seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        return TextDeserializationSchema.builder().seaTunnelRowType(seaTunnelRowType).delimiter("\b").build();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public Long getDiscoveryIntervalMillis() {
        return this.discoveryIntervalMillis;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public ConsumerMetaData getConsumerMetaData() {
        return this.consumerMetaData;
    }
}

