/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.catalog;

import com.mysql.cj.MysqlType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.SQLPreviewResult;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.starrocks.exception.StarRocksConnectorException;
import org.apache.seatunnel.connectors.seatunnel.starrocks.sink.StarRocksSaveModeUtil;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(StarRocksCatalog.class);
    protected final String catalogName;
    protected String defaultDatabase = "information_schema";
    protected final String username;
    protected final String pwd;
    protected final String baseUrl;
    protected String defaultUrl;
    private final JdbcUrlUtil.UrlInfo urlInfo;
    private final String template;
    private Connection conn;
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksCatalog.class);

    public StarRocksCatalog(String catalogName, String username, String pwd, String defaultUrl, String template) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(username));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(defaultUrl));
        this.urlInfo = JdbcUrlUtil.getUrlInfo((String)defaultUrl);
        this.baseUrl = this.urlInfo.getUrlWithoutDatabase();
        if (this.urlInfo.getDefaultDatabase().isPresent()) {
            this.defaultDatabase = (String)this.urlInfo.getDefaultDatabase().get();
        }
        this.defaultUrl = defaultUrl;
        this.catalogName = catalogName;
        this.username = username;
        this.pwd = pwd;
        this.template = template;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> listDatabases() throws CatalogException {
        try (PreparedStatement ps = this.conn.prepareStatement("SHOW DATABASES;");){
            ArrayList<String> arrayList;
            block15: {
                ResultSet rs = ps.executeQuery();
                try {
                    ArrayList<String> databases = new ArrayList<String>();
                    while (rs.next()) {
                        databases.add(rs.getString(1));
                    }
                    arrayList = databases;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        try (PreparedStatement ps = this.conn.prepareStatement("SELECT TABLE_NAME FROM information_schema.tables WHERE TABLE_SCHEMA = ? ORDER BY TABLE_NAME");){
            ArrayList<String> arrayList;
            block16: {
                ps.setString(1, databaseName);
                ResultSet rs = ps.executeQuery();
                try {
                    ArrayList<String> tables = new ArrayList<String>();
                    while (rs.next()) {
                        tables.add(rs.getString(1));
                    }
                    arrayList = tables;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        try {
            Optional<PrimaryKey> primaryKey = this.getPrimaryKey(tablePath.getDatabaseName(), tablePath.getTableName());
            PreparedStatement ps = this.conn.prepareStatement(String.format("SELECT * FROM %s WHERE 1 = 0;", tablePath.getFullNameWithQuoted()));
            ResultSetMetaData tableMetaData = ps.getMetaData();
            TableSchema.Builder builder = TableSchema.builder();
            this.buildColumnsWithErrorCheck(tablePath, builder, IntStream.range(1, tableMetaData.getColumnCount() + 1).iterator(), i -> {
                try {
                    SeaTunnelDataType<?> type = this.fromJdbcType(tableMetaData, (int)i);
                    return PhysicalColumn.of((String)tableMetaData.getColumnName((int)i), type, (Integer)tableMetaData.getColumnDisplaySize((int)i), (tableMetaData.isNullable((int)i) == 1 ? 1 : 0) != 0, null, (String)tableMetaData.getColumnLabel((int)i));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
            primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
            TableIdentifier tableIdentifier = TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName());
            return CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"");
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.createTable(StarRocksSaveModeUtil.INSTANCE.getCreateTableSql(this.template, tablePath.getDatabaseName(), tablePath.getTableName(), table.getTableSchema(), table.getComment(), StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE.key()));
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getDropTableSql(tablePath, ignoreIfNotExists));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            if (ignoreIfNotExists) {
                this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getTruncateTableSql(tablePath));
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed TRUNCATE TABLE in catalog %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void executeSql(TablePath tablePath, String sql) {
        try {
            this.conn.createStatement().execute(sql);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed EXECUTE SQL in catalog %s", sql), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isExistsData(TablePath tablePath) {
        String sql = String.format("select * from %s limit 1", tablePath.getFullName());
        try (Statement statement = this.conn.createStatement();){
            boolean bl;
            block18: {
                ResultSet resultSet;
                block16: {
                    boolean bl2;
                    block17: {
                        resultSet = statement.executeQuery(sql);
                        try {
                            if (resultSet != null) break block16;
                            bl2 = false;
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return bl2;
                }
                bl = resultSet.next();
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed Connection JDBC error %s", tablePath.getTableName()), (Throwable)e);
        }
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        try {
            this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getCreateDatabaseSql(tablePath.getDatabaseName(), ignoreIfExists));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        try {
            this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getDropDatabaseSql(tablePath.getDatabaseName(), ignoreIfNotExists));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    private SeaTunnelDataType<?> fromJdbcType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        MysqlType starrocksType = MysqlType.getByName((String)metadata.getColumnTypeName(colIndex));
        switch (starrocksType) {
            case NULL: {
                return BasicType.VOID_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case BIT: 
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case TINYINT_UNSIGNED: 
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case SMALLINT_UNSIGNED: 
            case INT: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: {
                return BasicType.INT_TYPE;
            }
            case INT_UNSIGNED: 
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                return BasicType.DOUBLE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case ENUM: {
                return BasicType.STRING_TYPE;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case GEOMETRY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                int precision = metadata.getPrecision(colIndex);
                int scale = metadata.getScale(colIndex);
                return new DecimalType(precision, scale);
            }
        }
        throw new StarRocksConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("Doesn't support Starrocks type '%s' yet", starrocksType.getName()));
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "starrocks");
        options.put("url", this.baseUrl + tablePath.getDatabaseName());
        options.put("table-name", tablePath.getFullName());
        return options;
    }

    public void createTable(String sql) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        try {
            log.info("create table sql is :{}", (Object)sql);
            this.conn.createStatement().execute(sql);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed create table in catalog %s, sql :[%s]", this.catalogName, sql), (Throwable)e);
        }
    }

    public static boolean validateJdbcUrlWithoutDatabase(String url) {
        String[] parts = url.trim().split("\\/+");
        return parts.length == 2;
    }

    public static boolean validateJdbcUrlWithDatabase(String url) {
        String[] parts = url.trim().split("\\/+");
        return parts.length == 3;
    }

    public static String[] splitDefaultUrl(String defaultUrl) {
        String[] res = new String[2];
        int index = defaultUrl.lastIndexOf("/") + 1;
        res[0] = defaultUrl.substring(0, index);
        res[1] = defaultUrl.substring(index);
        return res;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void open() throws CatalogException {
        try {
            this.conn = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);
            this.conn.getCatalog();
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", this.defaultUrl), (Throwable)e);
        }
        LOG.info("Catalog {} established connection to {}", (Object)this.catalogName, (Object)this.defaultUrl);
    }

    public void close() throws CatalogException {
        LOG.info("Catalog {} closing", (Object)this.catalogName);
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new CatalogException("close doris catalog failed", (Throwable)e);
        }
    }

    public String name() {
        return this.catalogName;
    }

    protected Optional<PrimaryKey> getPrimaryKey(String schema, String table) throws SQLException {
        ArrayList<String> pkFields = new ArrayList<String>();
        try (ResultSet rs = this.conn.createStatement().executeQuery(String.format("SELECT COLUMN_NAME FROM information_schema.columns where TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' AND COLUMN_KEY = 'PRI' ORDER BY ORDINAL_POSITION", schema, table));){
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                pkFields.add(columnName);
            }
        }
        if (!pkFields.isEmpty()) {
            String pkName = "pk_" + String.join((CharSequence)"_", pkFields);
            return Optional.of(PrimaryKey.of((String)pkName, pkFields));
        }
        return Optional.empty();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(databaseName));
        return this.listDatabases().contains(databaseName);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try (PreparedStatement ps = this.conn.prepareStatement("SELECT TABLE_NAME FROM information_schema.tables WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ? ORDER BY TABLE_NAME");){
            boolean bl;
            block14: {
                ps.setString(1, tablePath.getDatabaseName());
                ps.setString(2, tablePath.getTableName());
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("check table [%s] exists failed", tablePath.getFullName()), (Throwable)e);
        }
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            Preconditions.checkArgument((boolean)catalogTable.isPresent(), (Object)"CatalogTable cannot be null");
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getCreateTableSql(this.template, tablePath.getDatabaseName(), tablePath.getTableName(), catalogTable.get().getTableSchema(), catalogTable.get().getComment(), StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE.key()));
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getDropTableSql(tablePath, true));
        }
        if (actionType == Catalog.ActionType.TRUNCATE_TABLE) {
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getTruncateTableSql(tablePath));
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getCreateDatabaseSql(tablePath.getDatabaseName(), true));
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new SQLPreviewResult("DROP DATABASE IF EXISTS `" + tablePath.getDatabaseName() + "`");
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }
}

