/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.SinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 1000000;
    private SinkConfig sinkConfig;

    public HttpHelper() {
    }

    public HttpHelper(SinkConfig sinkConfig) {
        this.sinkConfig = sinkConfig;
    }

    public HttpEntity getHttpEntity(CloseableHttpResponse resp) {
        int code = resp.getStatusLine().getStatusCode();
        if (200 != code) {
            log.warn("Request failed with code:{}", (Object)code);
            return null;
        }
        HttpEntity respEntity = resp.getEntity();
        if (null == respEntity) {
            log.warn("Request failed with empty response.");
            return null;
        }
        return respEntity;
    }

    public String doHttpPost(String postUrl, Map<String, String> header, String postBody) throws IOException {
        log.info("Executing POST from {}.", (Object)postUrl);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpPost httpPost = new HttpPost(postUrl);
                if (null != header) {
                    for (Map.Entry<String, String> entry : header.entrySet()) {
                        httpPost.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                httpPost.setEntity(new ByteArrayEntity(postBody.getBytes()));
                CloseableHttpResponse resp = httpClient.execute(httpPost);
                try {
                    HttpEntity respEntity = this.getHttpEntity(resp);
                    String string2 = string = respEntity != null ? EntityUtils.toString(respEntity, "UTF-8") : null;
                    if (resp == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resp.close();
            }
            return string;
        }
    }

    public String doHttpGet(String getUrl) throws IOException {
        log.info("Executing GET from {}.", (Object)getUrl);
        try (CloseableHttpClient httpclient = this.buildHttpClient();){
            String string;
            block16: {
                HttpEntity respEntity;
                CloseableHttpResponse resp;
                block14: {
                    String string2;
                    block15: {
                        HttpGet httpGet = new HttpGet(getUrl);
                        resp = httpclient.execute(httpGet);
                        try {
                            respEntity = resp.getEntity();
                            if (null != respEntity) break block14;
                            log.warn("Request failed with empty response.");
                            string2 = null;
                            if (resp == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resp != null) {
                                try {
                                    resp.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resp.close();
                    }
                    return string2;
                }
                string = EntityUtils.toString(respEntity);
                if (resp == null) break block16;
                resp.close();
            }
            return string;
        }
    }

    public Map<String, Object> doHttpGet(String getUrl, Map<String, String> header) throws IOException {
        log.info("Executing GET from {}.", (Object)getUrl);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            Map map;
            block18: {
                HttpEntity respEntity;
                CloseableHttpResponse resp;
                block16: {
                    Map<String, Object> map2;
                    block17: {
                        HttpGet httpGet = new HttpGet(getUrl);
                        if (null != header) {
                            for (Map.Entry<String, String> entry : header.entrySet()) {
                                httpGet.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                            }
                        }
                        resp = httpclient.execute(httpGet);
                        try {
                            respEntity = this.getHttpEntity(resp);
                            if (null != respEntity) break block16;
                            log.warn("Request failed with empty response.");
                            map2 = null;
                            if (resp == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resp != null) {
                                try {
                                    resp.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resp.close();
                    }
                    return map2;
                }
                map = (Map)JsonUtils.parseObject((String)EntityUtils.toString(respEntity), Map.class);
                if (resp == null) break block18;
                resp.close();
            }
            return map;
        }
    }

    public Map<String, Object> doHttpPut(String url, byte[] data, Map<String, String> header) throws IOException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().addInterceptorFirst((request, context) -> request.removeHeaders("Content-Length")).setRedirectStrategy(new DefaultRedirectStrategy(){

            @Override
            protected boolean isRedirectable(String method) {
                return true;
            }
        });
        try (CloseableHttpClient httpclient = httpClientBuilder.build();){
            Map map;
            block24: {
                HttpEntity respEntity;
                CloseableHttpResponse resp;
                block22: {
                    Map<String, Object> map2;
                    block23: {
                        block20: {
                            HashMap<String, Object> hashMap;
                            block21: {
                                HttpPut httpPut = new HttpPut(url);
                                if (null != header) {
                                    for (Map.Entry<String, String> entry : header.entrySet()) {
                                        httpPut.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                                    }
                                }
                                httpPut.setEntity(new ByteArrayEntity(data));
                                httpPut.setConfig(RequestConfig.custom().setSocketTimeout(this.sinkConfig.getHttpSocketTimeout()).setRedirectsEnabled(true).build());
                                resp = httpclient.execute(httpPut);
                                try {
                                    String errorText;
                                    int code = resp.getStatusLine().getStatusCode();
                                    if (200 == code) break block20;
                                    try {
                                        HttpEntity respEntity2 = resp.getEntity();
                                        errorText = EntityUtils.toString(respEntity2);
                                    }
                                    catch (Exception err) {
                                        errorText = "find errorText failed: " + err.getMessage();
                                    }
                                    log.warn("Request failed with code:{}, err:{}", (Object)code, (Object)errorText);
                                    HashMap<String, Object> errorMap = new HashMap<String, Object>();
                                    errorMap.put("Status", "Fail");
                                    errorMap.put("Message", errorText);
                                    hashMap = errorMap;
                                    if (resp == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    if (resp != null) {
                                        try {
                                            resp.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                resp.close();
                            }
                            return hashMap;
                        }
                        respEntity = resp.getEntity();
                        if (null != respEntity) break block22;
                        log.warn("Request failed with empty response.");
                        map2 = null;
                        if (resp == null) break block23;
                        resp.close();
                    }
                    return map2;
                }
                map = (Map)JsonUtils.parseObject((String)EntityUtils.toString(respEntity), Map.class);
                if (resp == null) break block24;
                resp.close();
            }
            return map;
        }
    }

    private CloseableHttpClient buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setRedirectStrategy(new DefaultRedirectStrategy(){

            @Override
            protected boolean isRedirectable(String method) {
                return true;
            }
        });
        return httpClientBuilder.build();
    }

    public boolean tryHttpConnection(String host) {
        try {
            URL url = new URL(host);
            HttpURLConnection co = (HttpURLConnection)url.openConnection();
            co.setConnectTimeout(1000000);
            co.connect();
            co.disconnect();
            return true;
        }
        catch (Exception e1) {
            log.warn("Failed to connect to address:{}", (Object)host, (Object)e1);
            return false;
        }
    }
}

