/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.sink;

import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.common.util.CatalogUtil;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksSaveModeUtil
extends CatalogUtil {
    private static final Logger log = LoggerFactory.getLogger(StarRocksSaveModeUtil.class);
    public static final StarRocksSaveModeUtil INSTANCE = new StarRocksSaveModeUtil();

    @Override
    public String columnToConnectorType(Column column) {
        Preconditions.checkNotNull((Object)column, (Object)"The column is required.");
        return String.format("`%s` %s %s %s", column.getName(), StarRocksSaveModeUtil.dataTypeToStarrocksType(column.getDataType(), column.getColumnLength() == null ? 0L : column.getColumnLength()), column.isNullable() ? "NULL" : "NOT NULL", StringUtils.isEmpty(column.getComment()) ? "" : "COMMENT '" + column.getComment().replace("'", "''").replace("\\", "\\\\") + "'");
    }

    private static String dataTypeToStarrocksType(SeaTunnelDataType<?> dataType, long length) {
        Preconditions.checkNotNull(dataType, (Object)"The SeaTunnel's data type is required.");
        switch (dataType.getSqlType()) {
            case NULL: 
            case TIME: {
                return "VARCHAR(8)";
            }
            case STRING: {
                if (length > 65533L || length <= 0L) {
                    return "STRING";
                }
                return "VARCHAR(" + length + ")";
            }
            case BYTES: {
                return "STRING";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case TINYINT: {
                return "TINYINT";
            }
            case SMALLINT: {
                return "SMALLINT";
            }
            case INT: {
                return "INT";
            }
            case BIGINT: {
                return "BIGINT";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DATE: {
                return "DATE";
            }
            case TIMESTAMP: {
                return "DATETIME";
            }
            case ARRAY: {
                return "ARRAY<" + StarRocksSaveModeUtil.dataTypeToStarrocksType(((ArrayType)dataType).getElementType(), Long.MAX_VALUE) + ">";
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                return String.format("Decimal(%d, %d)", decimalType.getPrecision(), decimalType.getScale());
            }
            case MAP: 
            case ROW: {
                return "JSON";
            }
        }
        throw new IllegalArgumentException("Unsupported SeaTunnel's data type: " + dataType);
    }
}

