/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.sink;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.DefaultSaveModeHandler;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.sink.SupportSchemaEvolutionSink;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.schema.SchemaChangeType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.starrocks.catalog.StarRocksCatalog;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.sink.StarRocksSinkWriter;

public class StarRocksSink
extends AbstractSimpleSink<SeaTunnelRow, Void>
implements SupportSaveMode,
SupportSchemaEvolutionSink,
SupportMultiTableSink {
    private final TableSchema tableSchema;
    private final SinkConfig sinkConfig;
    private final DataSaveMode dataSaveMode;
    private final SchemaSaveMode schemaSaveMode;
    private final CatalogTable catalogTable;

    public StarRocksSink(SinkConfig sinkConfig, CatalogTable catalogTable) {
        this.sinkConfig = sinkConfig;
        this.tableSchema = catalogTable.getTableSchema();
        this.catalogTable = catalogTable;
        this.dataSaveMode = sinkConfig.getDataSaveMode();
        this.schemaSaveMode = sinkConfig.getSchemaSaveMode();
    }

    public String getPluginName() {
        return "StarRocks";
    }

    @Override
    public StarRocksSinkWriter createWriter(SinkWriter.Context context) {
        TablePath sinkTablePath = this.catalogTable.getTablePath();
        return new StarRocksSinkWriter(this.sinkConfig, this.tableSchema, sinkTablePath);
    }

    public Optional<SaveModeHandler> getSaveModeHandler() {
        TablePath tablePath = TablePath.of((String)this.catalogTable.getTableId().getDatabaseName(), (String)this.catalogTable.getTableId().getSchemaName(), (String)this.catalogTable.getTableId().getTableName());
        StarRocksCatalog catalog = new StarRocksCatalog("StarRocks", this.sinkConfig.getUsername(), this.sinkConfig.getPassword(), this.sinkConfig.getJdbcUrl(), this.sinkConfig.getSaveModeCreateTemplate());
        return Optional.of(new DefaultSaveModeHandler(this.schemaSaveMode, this.dataSaveMode, (Catalog)catalog, tablePath, this.catalogTable, this.sinkConfig.getCustomSql()));
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.of(this.catalogTable);
    }

    public List<SchemaChangeType> supports() {
        return Arrays.asList(SchemaChangeType.ADD_COLUMN, SchemaChangeType.DROP_COLUMN, SchemaChangeType.RENAME_COLUMN, SchemaChangeType.UPDATE_COLUMN);
    }
}

