/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.sink;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.starrocks.sink.StarRocksSink;

@AutoService(value={Factory.class})
public class StarRocksSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "StarRocks";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{StarRocksSinkOptions.USERNAME, StarRocksSinkOptions.PASSWORD}).required(new Option[]{StarRocksSinkOptions.DATABASE, StarRocksSinkOptions.BASE_URL}).required(new Option[]{StarRocksSinkOptions.NODE_URLS}).optional(new Option[]{StarRocksSinkOptions.TABLE, StarRocksSinkOptions.LABEL_PREFIX, StarRocksSinkOptions.BATCH_MAX_SIZE, StarRocksSinkOptions.BATCH_MAX_BYTES, StarRocksSinkOptions.MAX_RETRIES, StarRocksSinkOptions.MAX_RETRY_BACKOFF_MS, StarRocksSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS, StarRocksSinkOptions.STARROCKS_CONFIG, StarRocksSinkOptions.ENABLE_UPSERT_DELETE, StarRocksSinkOptions.SCHEMA_SAVE_MODE, StarRocksSinkOptions.DATA_SAVE_MODE, SinkConnectorCommonOptions.MULTI_TABLE_SINK_REPLICA, StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE, StarRocksSinkOptions.HTTP_SOCKET_TIMEOUT_MS}).conditional(StarRocksSinkOptions.DATA_SAVE_MODE, (Object)DataSaveMode.CUSTOM_PROCESSING, new Option[]{StarRocksSinkOptions.CUSTOM_SQL}).build();
    }

    public List<String> excludeTablePlaceholderReplaceKeys() {
        return Arrays.asList(StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE.key());
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        CatalogTable catalogTable = context.getCatalogTable();
        SinkConfig sinkConfig = SinkConfig.of(context.getOptions());
        if (StringUtils.isBlank(sinkConfig.getTable())) {
            sinkConfig.setTable(catalogTable.getTableId().getTableName());
        }
        TableIdentifier rewriteTableId = TableIdentifier.of((String)catalogTable.getTableId().getCatalogName(), (String)sinkConfig.getDatabase(), null, (String)sinkConfig.getTable());
        CatalogTable finalCatalogTable = CatalogTable.of((TableIdentifier)rewriteTableId, (TableSchema)catalogTable.getTableSchema(), (Map)catalogTable.getOptions(), (List)catalogTable.getPartitionKeys(), (String)catalogTable.getComment());
        return () -> new StarRocksSink(sinkConfig, finalCatalogTable);
    }
}

