/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.starrocks.datatypes.StarRocksType;
import org.apache.seatunnel.connectors.seatunnel.starrocks.datatypes.StarRocksTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Logger log = LoggerFactory.getLogger(SchemaUtils.class);
    private static final String MIN_VERSION_TABLE_CHANGE_COLUMN = "3.3.2";

    private SchemaUtils() {
    }

    public static void applySchemaChange(SchemaChangeEvent event, Connection connection, TablePath tablePath) throws SQLException {
        if (event instanceof AlterTableColumnsEvent) {
            for (AlterTableColumnEvent columnEvent : ((AlterTableColumnsEvent)event).getEvents()) {
                SchemaUtils.applySchemaChange((SchemaChangeEvent)columnEvent, connection, tablePath);
            }
        } else if (event instanceof AlterTableChangeColumnEvent) {
            AlterTableChangeColumnEvent changeColumnEvent = (AlterTableChangeColumnEvent)event;
            if (!changeColumnEvent.getOldColumn().equals(changeColumnEvent.getColumn().getName()) && !SchemaUtils.columnExists(connection, tablePath, changeColumnEvent.getOldColumn()) && SchemaUtils.columnExists(connection, tablePath, changeColumnEvent.getColumn().getName())) {
                log.warn("Column {} already exists in table {}. Skipping change column operation. event: {}", new Object[]{changeColumnEvent.getColumn().getName(), tablePath.getFullName(), event});
                return;
            }
            SchemaUtils.applySchemaChange(connection, tablePath, changeColumnEvent);
        } else if (event instanceof AlterTableModifyColumnEvent) {
            SchemaUtils.applySchemaChange(connection, tablePath, (AlterTableModifyColumnEvent)event);
        } else if (event instanceof AlterTableAddColumnEvent) {
            AlterTableAddColumnEvent addColumnEvent = (AlterTableAddColumnEvent)event;
            if (SchemaUtils.columnExists(connection, tablePath, addColumnEvent.getColumn().getName())) {
                log.warn("Column {} already exists in table {}. Skipping add column operation. event: {}", new Object[]{addColumnEvent.getColumn().getName(), tablePath.getFullName(), event});
                return;
            }
            SchemaUtils.applySchemaChange(connection, tablePath, addColumnEvent);
        } else if (event instanceof AlterTableDropColumnEvent) {
            AlterTableDropColumnEvent dropColumnEvent = (AlterTableDropColumnEvent)event;
            if (!SchemaUtils.columnExists(connection, tablePath, dropColumnEvent.getColumn())) {
                log.warn("Column {} does not exist in table {}. Skipping drop column operation. event: {}", new Object[]{dropColumnEvent.getColumn(), tablePath.getFullName(), event});
                return;
            }
            SchemaUtils.applySchemaChange(connection, tablePath, dropColumnEvent);
        } else {
            throw new SeaTunnelException("Unsupported schemaChangeEvent : " + event.getEventType());
        }
    }

    public static void applySchemaChange(Connection connection, TablePath tablePath, AlterTableChangeColumnEvent event) throws SQLException {
        ComparableVersion currentVersion;
        ComparableVersion targetVersion = new ComparableVersion(MIN_VERSION_TABLE_CHANGE_COLUMN);
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT CURRENT_VERSION() as version");){
            resultSet.next();
            String version = resultSet.getString(1);
            log.debug("starrocks version: {}", (Object)version);
            String versionOne = version.split(" ")[0];
            currentVersion = new ComparableVersion(versionOne);
        }
        if (currentVersion.compareTo(targetVersion) >= 0) {
            StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE").append(" ").append(tablePath.getFullName()).append(" ").append("RENAME COLUMN").append(" ").append(SchemaUtils.quoteIdentifier(event.getOldColumn())).append(" TO ").append(SchemaUtils.quoteIdentifier(event.getColumn().getName()));
            if (event.getColumn().getComment() != null) {
                sqlBuilder.append(" ").append("COMMENT ").append("'").append(event.getColumn().getComment()).append("'");
            }
            if (event.getAfterColumn() != null) {
                sqlBuilder.append(" ").append("AFTER ").append(SchemaUtils.quoteIdentifier(event.getAfterColumn()));
            }
            String changeColumnSQL = sqlBuilder.toString();
            try (Statement statement = connection.createStatement();){
                log.info("Executing change column SQL: " + changeColumnSQL);
                statement.execute(changeColumnSQL);
            }
        } else {
            log.warn("versions prior to starrocks 3.3.2 do not support rename column operations");
        }
    }

    public static void applySchemaChange(Connection connection, TablePath tablePath, AlterTableModifyColumnEvent event) throws SQLException {
        BasicTypeDefine<StarRocksType> typeDefine = StarRocksTypeConverter.INSTANCE.reconvert(event.getColumn());
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE").append(" ").append(tablePath.getFullName()).append(" ").append("MODIFY COLUMN").append(" ").append(SchemaUtils.quoteIdentifier(event.getColumn().getName())).append(" ").append(typeDefine.getColumnType());
        if (event.getColumn().getComment() != null) {
            sqlBuilder.append(" ").append("COMMENT ").append("'").append(event.getColumn().getComment()).append("'");
        }
        if (event.getAfterColumn() != null) {
            sqlBuilder.append(" ").append("AFTER ").append(SchemaUtils.quoteIdentifier(event.getAfterColumn()));
        }
        String modifyColumnSQL = sqlBuilder.toString();
        try (Statement statement = connection.createStatement();){
            log.info("Executing modify column SQL: " + modifyColumnSQL);
            statement.execute(modifyColumnSQL);
        }
    }

    public static void applySchemaChange(Connection connection, TablePath tablePath, AlterTableAddColumnEvent event) throws SQLException {
        BasicTypeDefine<StarRocksType> typeDefine = StarRocksTypeConverter.INSTANCE.reconvert(event.getColumn());
        StringBuilder sqlBuilder = new StringBuilder().append("ALTER TABLE").append(" ").append(tablePath.getFullName()).append(" ").append("ADD COLUMN").append(" ").append(SchemaUtils.quoteIdentifier(event.getColumn().getName())).append(" ").append(typeDefine.getColumnType());
        if (event.getColumn().getComment() != null) {
            sqlBuilder.append(" ").append("COMMENT ").append("'").append(event.getColumn().getComment()).append("'");
        }
        if (event.getAfterColumn() != null) {
            sqlBuilder.append(" ").append("AFTER ").append(SchemaUtils.quoteIdentifier(event.getAfterColumn()));
        }
        String addColumnSQL = sqlBuilder.toString();
        try (Statement statement = connection.createStatement();){
            log.info("Executing add column SQL: " + addColumnSQL);
            statement.execute(addColumnSQL);
        }
    }

    public static void applySchemaChange(Connection connection, TablePath tablePath, AlterTableDropColumnEvent event) throws SQLException {
        String dropColumnSQL = String.format("ALTER TABLE %s DROP COLUMN %s", tablePath.getFullName(), SchemaUtils.quoteIdentifier(event.getColumn()));
        try (Statement statement = connection.createStatement();){
            log.info("Executing drop column SQL: {}", (Object)dropColumnSQL);
            statement.execute(dropColumnSQL);
        }
    }

    public static boolean columnExists(Connection connection, TablePath tablePath, String column) {
        boolean bl;
        block8: {
            String selectColumnSQL = String.format("SELECT %s FROM %s WHERE 1 != 1", SchemaUtils.quoteIdentifier(column), tablePath.getFullName());
            Statement statement = connection.createStatement();
            try {
                bl = statement.execute(selectColumnSQL);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.debug("Column {} does not exist in table {}", new Object[]{column, tablePath.getFullName(), e});
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public static String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }
}

