/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.catalog;

import com.mysql.cj.MysqlType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.SQLPreviewResult;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.starrocks.exception.StarRocksConnectorException;
import org.apache.seatunnel.connectors.seatunnel.starrocks.sink.StarRocksSaveModeUtil;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(StarRocksCatalog.class);
    protected final String catalogName;
    protected String defaultDatabase = "information_schema";
    protected final String username;
    protected final String pwd;
    protected final String baseUrl;
    protected String defaultUrl;
    private final JdbcUrlUtil.UrlInfo urlInfo;
    private final String template;
    private Connection conn;
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksCatalog.class);

    public StarRocksCatalog(String catalogName, String username, String pwd, String defaultUrl, String template) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(username));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(defaultUrl));
        this.urlInfo = JdbcUrlUtil.getUrlInfo((String)defaultUrl);
        this.baseUrl = this.urlInfo.getUrlWithoutDatabase();
        if (this.urlInfo.getDefaultDatabase().isPresent()) {
            this.defaultDatabase = (String)this.urlInfo.getDefaultDatabase().get();
        }
        this.defaultUrl = defaultUrl;
        this.catalogName = catalogName;
        this.username = username;
        this.pwd = pwd;
        this.template = template;
    }

    /*
     * Exception decompiling
     */
    public List<String> listDatabases() throws CatalogException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        try {
            Optional<PrimaryKey> primaryKey = this.getPrimaryKey(tablePath.getDatabaseName(), tablePath.getTableName());
            PreparedStatement ps = this.conn.prepareStatement(String.format("SELECT * FROM %s WHERE 1 = 0;", tablePath.getFullNameWithQuoted()));
            ResultSetMetaData tableMetaData = ps.getMetaData();
            TableSchema.Builder builder = TableSchema.builder();
            this.buildColumnsWithErrorCheck(tablePath, builder, IntStream.range(1, tableMetaData.getColumnCount() + 1).iterator(), i -> {
                try {
                    SeaTunnelDataType<?> type = this.fromJdbcType(tableMetaData, (int)i);
                    return PhysicalColumn.of((String)tableMetaData.getColumnName((int)i), type, (Integer)tableMetaData.getColumnDisplaySize((int)i), (tableMetaData.isNullable((int)i) == 1 ? 1 : 0) != 0, null, (String)tableMetaData.getColumnLabel((int)i));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
            primaryKey.ifPresent(arg_0 -> ((TableSchema.Builder)builder).primaryKey(arg_0));
            TableIdentifier tableIdentifier = TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName());
            return CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)builder.build(), this.buildConnectorOptions(tablePath), Collections.emptyList(), (String)"");
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed getting table %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.createTable(StarRocksSaveModeUtil.INSTANCE.getCreateTableSql(this.template, tablePath.getDatabaseName(), tablePath.getTableName(), table.getTableSchema(), table.getComment(), StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE.key()));
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getDropTableSql(tablePath, ignoreIfNotExists));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            if (ignoreIfNotExists) {
                this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getTruncateTableSql(tablePath));
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed TRUNCATE TABLE in catalog %s", tablePath.getFullName()), (Throwable)e);
        }
    }

    public void executeSql(TablePath tablePath, String sql) {
        try {
            this.conn.createStatement().execute(sql);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed EXECUTE SQL in catalog %s", sql), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isExistsData(TablePath tablePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        try {
            this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getCreateDatabaseSql(tablePath.getDatabaseName(), ignoreIfExists));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        try {
            this.conn.createStatement().execute(StarRocksSaveModeUtil.INSTANCE.getDropDatabaseSql(tablePath.getDatabaseName(), ignoreIfNotExists));
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing database in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    private SeaTunnelDataType<?> fromJdbcType(ResultSetMetaData metadata, int colIndex) throws SQLException {
        MysqlType starrocksType = MysqlType.getByName((String)metadata.getColumnTypeName(colIndex));
        switch (starrocksType) {
            case NULL: {
                return BasicType.VOID_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case BIT: 
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case TINYINT_UNSIGNED: 
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case SMALLINT_UNSIGNED: 
            case INT: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: {
                return BasicType.INT_TYPE;
            }
            case INT_UNSIGNED: 
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                return BasicType.DOUBLE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case ENUM: {
                return BasicType.STRING_TYPE;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case GEOMETRY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                int precision = metadata.getPrecision(colIndex);
                int scale = metadata.getScale(colIndex);
                return new DecimalType(precision, scale);
            }
        }
        throw new StarRocksConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, String.format("Doesn't support Starrocks type '%s' yet", starrocksType.getName()));
    }

    private Map<String, String> buildConnectorOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>(8);
        options.put("connector", "starrocks");
        options.put("url", this.baseUrl + tablePath.getDatabaseName());
        options.put("table-name", tablePath.getFullName());
        return options;
    }

    public void createTable(String sql) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        try {
            log.info("create table sql is :{}", (Object)sql);
            this.conn.createStatement().execute(sql);
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed create table in catalog %s, sql :[%s]", this.catalogName, sql), (Throwable)e);
        }
    }

    public static boolean validateJdbcUrlWithoutDatabase(String url) {
        String[] parts = url.trim().split("\\/+");
        return parts.length == 2;
    }

    public static boolean validateJdbcUrlWithDatabase(String url) {
        String[] parts = url.trim().split("\\/+");
        return parts.length == 3;
    }

    public static String[] splitDefaultUrl(String defaultUrl) {
        String[] res = new String[2];
        int index = defaultUrl.lastIndexOf("/") + 1;
        res[0] = defaultUrl.substring(0, index);
        res[1] = defaultUrl.substring(index);
        return res;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void open() throws CatalogException {
        try {
            this.conn = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);
            this.conn.getCatalog();
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", this.defaultUrl), (Throwable)e);
        }
        LOG.info("Catalog {} established connection to {}", (Object)this.catalogName, (Object)this.defaultUrl);
    }

    public void close() throws CatalogException {
        LOG.info("Catalog {} closing", (Object)this.catalogName);
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new CatalogException("close doris catalog failed", (Throwable)e);
        }
    }

    public String name() {
        return this.catalogName;
    }

    protected Optional<PrimaryKey> getPrimaryKey(String schema, String table) throws SQLException {
        ArrayList<String> pkFields = new ArrayList<String>();
        try (ResultSet rs = this.conn.createStatement().executeQuery(String.format("SELECT COLUMN_NAME FROM information_schema.columns where TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' AND COLUMN_KEY = 'PRI' ORDER BY ORDINAL_POSITION", schema, table));){
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                pkFields.add(columnName);
            }
        }
        if (!pkFields.isEmpty()) {
            String pkName = "pk_" + String.join((CharSequence)"_", pkFields);
            return Optional.of(PrimaryKey.of((String)pkName, pkFields));
        }
        return Optional.empty();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(databaseName));
        return this.listDatabases().contains(databaseName);
    }

    /*
     * Exception decompiling
     */
    public boolean tableExists(TablePath tablePath) throws CatalogException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            Preconditions.checkArgument((boolean)catalogTable.isPresent(), (Object)"CatalogTable cannot be null");
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getCreateTableSql(this.template, tablePath.getDatabaseName(), tablePath.getTableName(), catalogTable.get().getTableSchema(), catalogTable.get().getComment(), StarRocksSinkOptions.SAVE_MODE_CREATE_TEMPLATE.key()));
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getDropTableSql(tablePath, true));
        }
        if (actionType == Catalog.ActionType.TRUNCATE_TABLE) {
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getTruncateTableSql(tablePath));
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new SQLPreviewResult(StarRocksSaveModeUtil.INSTANCE.getCreateDatabaseSql(tablePath.getDatabaseName(), true));
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new SQLPreviewResult("DROP DATABASE IF EXISTS `" + tablePath.getDatabaseName() + "`");
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }
}

