/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.serialize;

import java.util.LinkedHashMap;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksBaseSerializer;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksISerializer;
import org.apache.seatunnel.connectors.seatunnel.starrocks.serialize.StarRocksSinkOP;

public class StarRocksJsonSerializer
extends StarRocksBaseSerializer
implements StarRocksISerializer {
    private static final long serialVersionUID = 1L;
    private final SeaTunnelRowType seaTunnelRowType;
    private final boolean enableUpsertDelete;

    public StarRocksJsonSerializer(SeaTunnelRowType seaTunnelRowType, boolean enableUpsertDelete) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.enableUpsertDelete = enableUpsertDelete;
    }

    @Override
    public String serialize(SeaTunnelRow row) {
        LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>(row.getFields().length);
        for (int i = 0; i < row.getFields().length; ++i) {
            SqlType sqlType = this.seaTunnelRowType.getFieldType(i).getSqlType();
            Object value = sqlType == SqlType.ARRAY || sqlType == SqlType.MAP || sqlType == SqlType.ROW || sqlType == SqlType.MULTIPLE_ROW ? row.getField(i) : this.convert(this.seaTunnelRowType.getFieldType(i), row.getField(i));
            rowMap.put(this.seaTunnelRowType.getFieldName(i), value);
        }
        if (this.enableUpsertDelete) {
            rowMap.put("__op", StarRocksSinkOP.parse(row.getRowKind()).ordinal());
        }
        return JsonUtils.toJsonString(rowMap);
    }
}

