/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.starrocks.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.starrocks.client.source.StarRocksQueryPlanReadClient;
import org.apache.seatunnel.connectors.seatunnel.starrocks.client.source.model.QueryPartition;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.config.StarRocksSourceTableConfig;
import org.apache.seatunnel.connectors.seatunnel.starrocks.source.StarRocksSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.starrocks.source.StarRocksSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartRocksSourceSplitEnumerator
implements SourceSplitEnumerator<StarRocksSourceSplit, StarRocksSourceState> {
    private static final Logger log = LoggerFactory.getLogger(StartRocksSourceSplitEnumerator.class);
    private SourceConfig sourceConfig;
    private StarRocksQueryPlanReadClient starRocksQueryPlanReadClient;
    private final Map<Integer, List<StarRocksSourceSplit>> pendingSplit;
    private final ConcurrentLinkedQueue<String> pendingTables;
    private final Object stateLock = new Object();
    private final SourceSplitEnumerator.Context<StarRocksSourceSplit> context;

    public StartRocksSourceSplitEnumerator(SourceSplitEnumerator.Context<StarRocksSourceSplit> context, SourceConfig sourceConfig) {
        this(context, sourceConfig, null);
    }

    public StartRocksSourceSplitEnumerator(SourceSplitEnumerator.Context<StarRocksSourceSplit> context, SourceConfig sourceConfig, StarRocksSourceState sourceState) {
        this.sourceConfig = sourceConfig;
        this.starRocksQueryPlanReadClient = new StarRocksQueryPlanReadClient(sourceConfig);
        List tables = sourceConfig.getTableConfigList().stream().map(StarRocksSourceTableConfig::getTable).collect(Collectors.toList());
        this.context = context;
        this.pendingSplit = new HashMap<Integer, List<StarRocksSourceSplit>>();
        this.pendingTables = new ConcurrentLinkedQueue(tables);
        if (sourceState != null) {
            this.pendingSplit.putAll(sourceState.getPendingSplit());
            this.pendingTables.addAll(sourceState.getPendingTables());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Set readers = this.context.registeredReaders();
        while (!this.pendingTables.isEmpty()) {
            object = this.stateLock;
            synchronized (object) {
                String table = this.pendingTables.poll();
                log.info("Splitting table {}.", (Object)table);
                List<StarRocksSourceSplit> newSplits = this.getStarRocksSourceSplit(table);
                log.info("Split table {} into {} splits.", (Object)table, (Object)newSplits.size());
                this.addPendingSplit(newSplits);
            }
        }
        object = this.stateLock;
        synchronized (object) {
            this.assignSplit(readers);
        }
        log.debug("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> this.context.signalNoMoreSplits(arg_0));
    }

    public void addSplitsBack(List<StarRocksSourceSplit> splits, int subtaskId) {
        log.debug("Add back splits {} to StartRocksSourceSplitEnumerator.", splits);
        if (!splits.isEmpty()) {
            this.addPendingSplit(splits);
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplit.size();
    }

    public void registerReader(int subtaskId) {
        log.debug("Register reader {} to StartRocksSourceSplitEnumerator.", (Object)subtaskId);
        if (!this.pendingSplit.isEmpty()) {
            this.assignSplit(Collections.singletonList(subtaskId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StarRocksSourceState snapshotState(long checkpointId) {
        Object object = this.stateLock;
        synchronized (object) {
            return new StarRocksSourceState(this.pendingSplit, this.pendingTables);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    public void open() {
    }

    public void close() {
    }

    public void handleSplitRequest(int subtaskId) {
        throw CommonError.unsupportedOperation((String)String.format("SubTask: %d", subtaskId), (String)"handleSplitRequest");
    }

    private void addPendingSplit(Collection<StarRocksSourceSplit> splits) {
        int readerCount = this.context.currentParallelism();
        for (StarRocksSourceSplit split : splits) {
            int ownerReader = StartRocksSourceSplitEnumerator.getSplitOwner(split.splitId(), readerCount);
            log.info("Assigning {} to {} reader.", (Object)split.getSplitId(), (Object)ownerReader);
            this.pendingSplit.computeIfAbsent(ownerReader, r -> new ArrayList()).add(split);
        }
    }

    private void assignSplit(Collection<Integer> readers) {
        log.debug("Assign pendingSplits to readers {}", readers);
        for (int reader : readers) {
            List<StarRocksSourceSplit> assignmentForReader = this.pendingSplit.remove(reader);
            if (assignmentForReader == null || assignmentForReader.isEmpty()) continue;
            log.info("Assign splits {} to reader {}", (Object)assignmentForReader.stream().map(StarRocksSourceSplit::getSplitId).collect(Collectors.joining(",")), (Object)reader);
            try {
                this.context.assignSplit(reader, assignmentForReader);
            }
            catch (Exception e) {
                log.error("Failed to assign splits {} to reader {}", new Object[]{assignmentForReader, reader, e});
                this.pendingSplit.put(reader, assignmentForReader);
            }
        }
    }

    List<StarRocksSourceSplit> getStarRocksSourceSplit(String table) {
        ArrayList<StarRocksSourceSplit> sourceSplits = new ArrayList<StarRocksSourceSplit>();
        List<QueryPartition> partitions = this.starRocksQueryPlanReadClient.findPartitions(table);
        for (int i = 0; i < partitions.size(); ++i) {
            sourceSplits.add(new StarRocksSourceSplit(partitions.get(i), String.valueOf(partitions.get(i).hashCode())));
        }
        return sourceSplits;
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }
}

