/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.UnicastSubject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowBoundarySelector<T, B, V>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final ObservableSource<B> open;
    final Function<? super B, ? extends ObservableSource<V>> close;
    final int bufferSize;

    public ObservableWindowBoundarySelector(ObservableSource<T> source2, ObservableSource<B> open, Function<? super B, ? extends ObservableSource<V>> close, int bufferSize) {
        super(source2);
        this.open = open;
        this.close = close;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> t) {
        this.source.subscribe(new WindowBoundaryMainObserver(new SerializedObserver<Observable<T>>(t), this.open, this.close, this.bufferSize));
    }

    static final class OperatorWindowBoundaryCloseObserver<T, V>
    extends DisposableObserver<V> {
        final WindowBoundaryMainObserver<T, ?, V> parent;
        final UnicastSubject<T> w;
        boolean done;

        OperatorWindowBoundaryCloseObserver(WindowBoundaryMainObserver<T, ?, V> parent, UnicastSubject<T> w) {
            this.parent = parent;
            this.w = w;
        }

        @Override
        public void onNext(V t) {
            this.dispose();
            this.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.error(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.close(this);
        }
    }

    static final class OperatorWindowBoundaryOpenObserver<T, B>
    extends DisposableObserver<B> {
        final WindowBoundaryMainObserver<T, B, ?> parent;

        OperatorWindowBoundaryOpenObserver(WindowBoundaryMainObserver<T, B, ?> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            this.parent.open(t);
        }

        @Override
        public void onError(Throwable t) {
            this.parent.error(t);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class WindowOperation<T, B> {
        final UnicastSubject<T> w;
        final B open;

        WindowOperation(UnicastSubject<T> w, B open) {
            this.w = w;
            this.open = open;
        }
    }

    static final class WindowBoundaryMainObserver<T, B, V>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Disposable {
        final ObservableSource<B> open;
        final Function<? super B, ? extends ObservableSource<V>> close;
        final int bufferSize;
        final CompositeDisposable resources;
        Disposable upstream;
        final AtomicReference<Disposable> boundary = new AtomicReference();
        final List<UnicastSubject<T>> ws;
        final AtomicLong windows = new AtomicLong();

        WindowBoundaryMainObserver(Observer<? super Observable<T>> actual, ObservableSource<B> open, Function<? super B, ? extends ObservableSource<V>> close, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.open = open;
            this.close = close;
            this.bufferSize = bufferSize;
            this.resources = new CompositeDisposable();
            this.ws = new ArrayList<UnicastSubject<T>>();
            this.windows.lazySet(1L);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                OperatorWindowBoundaryOpenObserver os = new OperatorWindowBoundaryOpenObserver(this);
                if (this.boundary.compareAndSet(null, os)) {
                    this.windows.getAndIncrement();
                    this.open.subscribe(os);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.fastEnter()) {
                for (UnicastSubject<T> w : this.ws) {
                    w.onNext(t);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                this.resources.dispose();
            }
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            if (this.windows.decrementAndGet() == 0L) {
                this.resources.dispose();
            }
            this.downstream.onComplete();
        }

        void error(Throwable t) {
            this.upstream.dispose();
            this.resources.dispose();
            this.onError(t);
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeBoundary() {
            this.resources.dispose();
            DisposableHelper.dispose(this.boundary);
        }

        void drainLoop() {
            MpscLinkedQueue q = (MpscLinkedQueue)this.queue;
            Observer a = this.downstream;
            List<UnicastSubject<T>> ws = this.ws;
            int missed = 1;
            block2: while (true) {
                boolean empty;
                boolean d = this.done;
                Object o = q.poll();
                boolean bl = empty = o == null;
                if (d && empty) {
                    this.disposeBoundary();
                    Throwable e = this.error;
                    if (e != null) {
                        for (UnicastSubject<T> w : ws) {
                            w.onError(e);
                        }
                    } else {
                        for (UnicastSubject<T> w : ws) {
                            w.onComplete();
                        }
                    }
                    ws.clear();
                    return;
                }
                if (!empty) {
                    UnicastSubject w;
                    if (o instanceof WindowOperation) {
                        ObservableSource<V> p;
                        WindowOperation wo = (WindowOperation)o;
                        w = wo.w;
                        if (w != null) {
                            if (!ws.remove(wo.w)) continue;
                            wo.w.onComplete();
                            if (this.windows.decrementAndGet() != 0L) continue;
                            this.disposeBoundary();
                            return;
                        }
                        if (this.cancelled) continue;
                        w = UnicastSubject.create(this.bufferSize);
                        ws.add(w);
                        a.onNext(w);
                        try {
                            p = ObjectHelper.requireNonNull(this.close.apply(wo.open), "The ObservableSource supplied is null");
                        }
                        catch (Throwable e) {
                            Exceptions.throwIfFatal(e);
                            this.cancelled = true;
                            a.onError(e);
                            continue;
                        }
                        OperatorWindowBoundaryCloseObserver cl = new OperatorWindowBoundaryCloseObserver(this, w);
                        if (!this.resources.add(cl)) continue;
                        this.windows.getAndIncrement();
                        p.subscribe(cl);
                        continue;
                    }
                    Iterator<UnicastSubject<T>> iterator2 = ws.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block2;
                        w = iterator2.next();
                        w.onNext(NotificationLite.getValue(o));
                    }
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        @Override
        public void accept(Observer<? super Observable<T>> a, Object v) {
        }

        void open(B b) {
            this.queue.offer(new WindowOperation(null, b));
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void close(OperatorWindowBoundaryCloseObserver<T, V> w) {
            this.resources.delete(w);
            this.queue.offer(new WindowOperation(w.w, null));
            if (this.enter()) {
                this.drainLoop();
            }
        }
    }
}

