/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Type;

public abstract class Array<T extends Type>
implements Type<List<T>> {
    private final Class<T> type;
    protected final List<T> value;

    @Deprecated
    @SafeVarargs
    Array(String type, T ... values2) {
        this(type, Arrays.asList(values2));
    }

    @Deprecated
    Array(String type, List<T> values2) {
        this(AbiTypes.getType(type), values2);
    }

    @Deprecated
    Array(String type) {
        this(type, (List<T>)new ArrayList());
    }

    @SafeVarargs
    Array(Class<T> type, T ... values2) {
        this(type, Arrays.asList(values2));
    }

    Array(Class<T> type, List<T> values2) {
        this.checkValid(type, values2);
        this.type = type;
        this.value = values2;
    }

    @Override
    public int bytes32PaddedLength() {
        int length = 0;
        for (Type t : this.value) {
            int valueLength = t.bytes32PaddedLength();
            length += valueLength;
        }
        return length;
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    public Class<T> getComponentType() {
        return this.type;
    }

    @Override
    public abstract String getTypeAsString();

    private void checkValid(Class<T> type, List<T> values2) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(values2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Array array = (Array)o;
        if (!this.type.equals(array.type)) {
            return false;
        }
        return Objects.equals(this.value, array.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

