/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;

public class EthSyncing
extends Response<Result> {
    @Override
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(Result result) {
        super.setResult(result);
    }

    public boolean isSyncing() {
        return ((Result)this.getResult()).isSyncing();
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<Result> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        @Override
        public Result deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Result result;
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_FALSE) {
                result = new Result();
                result.setSyncing(jsonParser.getBooleanValue());
            } else {
                result = this.objectReader.readValue(jsonParser, Syncing.class);
            }
            return result;
        }
    }

    @JsonIgnoreProperties(value={"knownStates", "pulledStates"})
    public static class Syncing
    extends Result {
        private String startingBlock;
        private String currentBlock;
        private String highestBlock;
        private String knownStates;
        private String pulledStates;

        public Syncing() {
        }

        public Syncing(String startingBlock, String currentBlock, String highestBlock, String knownStates, String pulledStates) {
            this.startingBlock = startingBlock;
            this.currentBlock = currentBlock;
            this.highestBlock = highestBlock;
            this.knownStates = knownStates;
            this.pulledStates = pulledStates;
        }

        public String getStartingBlock() {
            return this.startingBlock;
        }

        public void setStartingBlock(String startingBlock) {
            this.startingBlock = startingBlock;
        }

        public String getCurrentBlock() {
            return this.currentBlock;
        }

        public void setCurrentBlock(String currentBlock) {
            this.currentBlock = currentBlock;
        }

        public String getHighestBlock() {
            return this.highestBlock;
        }

        public void setHighestBlock(String highestBlock) {
            this.highestBlock = highestBlock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Syncing)) {
                return false;
            }
            Syncing syncing = (Syncing)o;
            if (this.isSyncing() != syncing.isSyncing()) {
                return false;
            }
            if (this.getStartingBlock() != null ? !this.getStartingBlock().equals(syncing.getStartingBlock()) : syncing.getStartingBlock() != null) {
                return false;
            }
            if (this.getCurrentBlock() != null ? !this.getCurrentBlock().equals(syncing.getCurrentBlock()) : syncing.getCurrentBlock() != null) {
                return false;
            }
            if (this.getHighestBlock() != null ? !this.getHighestBlock().equals(syncing.getHighestBlock()) : syncing.getHighestBlock() != null) {
                return false;
            }
            if (this.knownStates != null ? !this.knownStates.equals(syncing.knownStates) : syncing.knownStates != null) {
                return false;
            }
            return this.pulledStates != null ? this.pulledStates.equals(syncing.pulledStates) : syncing.pulledStates == null;
        }

        public int hashCode() {
            int result = this.getStartingBlock() != null ? this.getStartingBlock().hashCode() : 0;
            result = 31 * result + Boolean.hashCode(this.isSyncing());
            result = 31 * result + (this.getCurrentBlock() != null ? this.getCurrentBlock().hashCode() : 0);
            result = 31 * result + (this.getHighestBlock() != null ? this.getHighestBlock().hashCode() : 0);
            result = 31 * result + (this.knownStates != null ? this.knownStates.hashCode() : 0);
            result = 31 * result + (this.pulledStates != null ? this.pulledStates.hashCode() : 0);
            return result;
        }
    }

    public static class Result {
        private boolean isSyncing = true;

        public boolean isSyncing() {
            return this.isSyncing;
        }

        public void setSyncing(boolean syncing) {
            this.isSyncing = syncing;
        }
    }
}

