/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.websocket;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.websocket.WebSocketListener;

public class WebSocketClient
extends org.java_websocket.client.WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private Optional<WebSocketListener> listenerOpt = Optional.empty();

    public WebSocketClient(URI serverUri) {
        super(serverUri);
    }

    public WebSocketClient(URI serverUri, Map<String, String> httpHeaders) {
        super(serverUri, httpHeaders);
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        log.debug("Opened WebSocket connection to {}", (Object)this.uri);
    }

    @Override
    public void onMessage(String s) {
        log.debug("Received message {} from server {}", (Object)s, (Object)this.uri);
        this.listenerOpt.ifPresent(listener -> {
            try {
                listener.onMessage(s);
            }
            catch (Exception e) {
                log.error("Failed to process message '{}' from server {}", new Object[]{s, this.uri, e});
            }
        });
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        log.debug("Closed WebSocket connection to {}, because of reason: '{}'.Connection closed remotely: {}", new Object[]{this.uri, reason, remote});
        this.listenerOpt.ifPresent(WebSocketListener::onClose);
    }

    @Override
    public void onError(Exception e) {
        log.error("WebSocket connection to {} failed with error", (Object)this.uri, (Object)e);
        this.listenerOpt.ifPresent(listener -> listener.onError(e));
    }

    public void setListener(WebSocketListener listener) {
        this.listenerOpt = Optional.ofNullable(listener);
    }
}

