/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.oracle.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.api.utils.JdbcUtils;
import org.apache.seatunnel.datasource.plugin.oracle.jdbc.OracleDataSourceConfig;
import org.apache.seatunnel.datasource.plugin.oracle.jdbc.OracleOptionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDataSourceChannel
implements DataSourceChannel {
    private static final Logger log = LoggerFactory.getLogger(OracleDataSourceChannel.class);

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return OracleDataSourceConfig.OPTION_RULE;
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return OracleDataSourceConfig.METADATA_RULE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getTables(@NonNull String pluginName, Map<String, String> requestParams, String database, Map<String, String> options) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        StringBuilder sqlWhere = new StringBuilder();
        String sql = "SELECT * FROM ( SELECT OWNER, TABLE_NAME FROM ALL_TABLES\nWHERE TABLE_NAME NOT LIKE 'MDRT_%'\n  AND TABLE_NAME NOT LIKE 'MDRS_%'\n  AND TABLE_NAME NOT LIKE 'MDXT_%'\n  AND (TABLE_NAME NOT LIKE 'SYS_IOT_OVER_%' AND IOT_NAME IS NULL)AND OWNER NOT IN ('APPQOSSYS', 'AUDSYS', 'CTXSYS', 'DVSYS', 'DBSFWUSER', 'DBSNMP',\n                    'GSMADMIN_INTERNAL', 'LBACSYS', 'MDSYS', 'OJVMSYS', 'OLAPSYS',\n                    'ORDDATA', 'ORDSYS', 'OUTLN', 'SYS', 'SYSTEM', 'WMSYS',\n                    'XDB', 'EXFSYS', 'SYSMAN')";
        sqlWhere.append("SELECT * FROM ( SELECT OWNER, TABLE_NAME FROM ALL_TABLES\nWHERE TABLE_NAME NOT LIKE 'MDRT_%'\n  AND TABLE_NAME NOT LIKE 'MDRS_%'\n  AND TABLE_NAME NOT LIKE 'MDXT_%'\n  AND (TABLE_NAME NOT LIKE 'SYS_IOT_OVER_%' AND IOT_NAME IS NULL)AND OWNER NOT IN ('APPQOSSYS', 'AUDSYS', 'CTXSYS', 'DVSYS', 'DBSFWUSER', 'DBSNMP',\n                    'GSMADMIN_INTERNAL', 'LBACSYS', 'MDSYS', 'OJVMSYS', 'OLAPSYS',\n                    'ORDDATA', 'ORDSYS', 'OUTLN', 'SYS', 'SYSTEM', 'WMSYS',\n                    'XDB', 'EXFSYS', 'SYSMAN')");
        String filterName = options.get("filterName");
        if (StringUtils.isNotEmpty(filterName)) {
            String[] split = filterName.split("\\.");
            if (split.length == 2) {
                sqlWhere.append(" AND (TABLE_NAME LIKE '").append(split[1].contains("%") ? split[1].toUpperCase(Locale.ROOT) : "%" + split[1].toUpperCase(Locale.ROOT) + "%").append("'").append(" AND OWNER LIKE '").append(split[0].contains("%") ? split[0].toUpperCase(Locale.ROOT) : "%" + split[0].toUpperCase(Locale.ROOT) + "%").append("')");
            } else {
                String filterNameRep = filterName.contains("%") ? filterName.toUpperCase(Locale.ROOT) : "%" + filterName.toUpperCase(Locale.ROOT) + "%";
                sqlWhere.append(" AND (TABLE_NAME LIKE '%").append(filterNameRep).append("%'").append(" OR OWNER LIKE '%").append(filterNameRep).append("%')");
            }
        }
        sqlWhere.append(" ORDER BY OWNER, TABLE_NAME ) ");
        String size = options.get("size");
        if (StringUtils.isNotEmpty(size)) {
            sqlWhere.append("WHERE ROWNUM <= ").append(size);
        }
        log.info("execute sql :{}", (Object)sqlWhere.toString());
        ArrayList<String> tableNames = new ArrayList<String>();
        long start = System.currentTimeMillis();
        try (Connection connection = this.getConnection(requestParams);){
            long end = System.currentTimeMillis();
            log.info("connection, cost {}ms for oracle", (Object)(end - start));
            start = System.currentTimeMillis();
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(sqlWhere.toString());){
                end = System.currentTimeMillis();
                log.info("statement execute sql, cost {}ms for oracle", (Object)(end - start));
                start = System.currentTimeMillis();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("OWNER");
                    String tableName = resultSet.getString("TABLE_NAME");
                    tableNames.add(schemaName + "." + tableName);
                }
                end = System.currentTimeMillis();
                log.info("while result set, cost {}ms for oracle", (Object)(end - start));
            }
            ArrayList<String> arrayList = tableNames;
            return arrayList;
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DataSourcePluginException("get table names failed", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> getDatabases(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(@NonNull String pluginName, @NonNull Map<String, String> requestParams) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        try (Connection ignored = this.getConnection(requestParams);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DataSourcePluginException("check jdbc connectivity failed", (Throwable)e);
        }
    }

    public List<TableField> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull String table) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        ArrayList<TableField> tableFields = new ArrayList<TableField>();
        try (Connection connection = this.getConnection(requestParams, database);){
            DatabaseMetaData metaData = connection.getMetaData();
            String primaryKey = this.getPrimaryKey(metaData, database, table);
            try (ResultSet resultSet = metaData.getColumns(database, null, table, null);){
                while (resultSet.next()) {
                    TableField tableField = new TableField();
                    String columnName = resultSet.getString("COLUMN_NAME");
                    tableField.setPrimaryKey(Boolean.valueOf(false));
                    if (StringUtils.isNotBlank(primaryKey) && primaryKey.equals(columnName)) {
                        tableField.setPrimaryKey(Boolean.valueOf(true));
                    }
                    tableField.setName(columnName);
                    tableField.setType(resultSet.getString("TYPE_NAME"));
                    tableField.setComment(resultSet.getString("REMARKS"));
                    Object nullable = resultSet.getObject("IS_NULLABLE");
                    tableField.setNullable(Boolean.valueOf(Boolean.TRUE.toString().equals(nullable.toString())));
                    tableFields.add(tableField);
                }
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DataSourcePluginException("get table fields failed", (Throwable)e);
        }
        return tableFields;
    }

    public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        return null;
    }

    private String getPrimaryKey(DatabaseMetaData metaData, String dbName, String tableName) throws SQLException {
        ResultSet primaryKeysInfo = metaData.getPrimaryKeys(dbName, "%", tableName);
        if (primaryKeysInfo.next()) {
            return primaryKeysInfo.getString("COLUMN_NAME");
        }
        return null;
    }

    private Connection getConnection(Map<String, String> requestParams) throws SQLException, ClassNotFoundException {
        return this.getConnection(requestParams, null);
    }

    private Connection getConnection(Map<String, String> requestParams, String databaseName) throws SQLException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)requestParams.get(OracleOptionRule.DRIVER.key()));
        Preconditions.checkNotNull((Object)requestParams.get(OracleOptionRule.URL.key()), (Object)"Jdbc url cannot be null");
        String url = JdbcUtils.replaceDatabase((String)requestParams.get(OracleOptionRule.URL.key()), (String)databaseName);
        if (requestParams.containsKey(OracleOptionRule.USER.key())) {
            String username = requestParams.get(OracleOptionRule.USER.key());
            String password = requestParams.get(OracleOptionRule.PASSWORD.key());
            return DriverManager.getConnection(url, username, password);
        }
        return DriverManager.getConnection(url);
    }
}

