/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.cdc.sqlserver;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.cdc.sqlserver.SqlServerCDCOptionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerCDCDataSourceChannel
implements DataSourceChannel {
    private static final Logger log = LoggerFactory.getLogger(SqlServerCDCDataSourceChannel.class);
    public static final Set<String> MYSQL_SYSTEM_DATABASES = Sets.newHashSet((Object[])new String[]{"master", "tempdb", "model", "msdb"});

    public boolean canAbleGetSchema() {
        return true;
    }

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return SqlServerCDCOptionRule.optionRule();
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return SqlServerCDCOptionRule.metadataRule();
    }

    public List<String> getTables(String pluginName, Map<String, String> requestParams, String database, Map<String, String> options) {
        return this.getTableNames(requestParams, database, options);
    }

    public List<String> getDatabases(String pluginName, Map<String, String> requestParams) {
        try {
            return this.getDataBaseNames(requestParams);
        }
        catch (SQLException e) {
            throw new DataSourcePluginException("get databases failed", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean checkDataSourceConnectivity(String pluginName, Map<String, String> requestParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<TableField> getTableFields(String pluginName, Map<String, String> requestParams, String database, String table) {
        Pair<String, String> pair = this.parseSchemaAndTable(table);
        return this.getTableFields(requestParams, database, pair.getLeft(), pair.getRight());
    }

    public Map<String, List<TableField>> getTableFields(String pluginName, Map<String, String> requestParams, String database, List<String> tables) {
        HashMap<String, List<TableField>> tableFields = new HashMap<String, List<TableField>>(tables.size());
        for (String table : tables) {
            tableFields.put(table, this.getTableFields(pluginName, requestParams, database, table));
        }
        return tableFields;
    }

    private Connection init(Map<String, String> requestParams) throws SQLException {
        if (null == requestParams.get(SqlServerCDCOptionRule.BASE_URL.key())) {
            throw new DataSourcePluginException("Jdbc url is null");
        }
        String url = requestParams.get(SqlServerCDCOptionRule.BASE_URL.key());
        if (null != requestParams.get(SqlServerCDCOptionRule.PASSWORD.key()) && null != requestParams.get(SqlServerCDCOptionRule.USERNAME.key())) {
            String username = requestParams.get(SqlServerCDCOptionRule.USERNAME.key());
            String password = requestParams.get(SqlServerCDCOptionRule.PASSWORD.key());
            return DriverManager.getConnection(url, username, password);
        }
        return DriverManager.getConnection(url);
    }

    /*
     * Exception decompiling
     */
    private List<String> getDataBaseNames(Map<String, String> requestParams) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<String> getTableNames(Map<String, String> requestParams, String dbName, Map<String, String> options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<TableField> getTableFields(Map<String, String> requestParams, String dbName, String schemaName, String tableName) {
        ArrayList<TableField> tableFields = new ArrayList<TableField>();
        try (Connection connection = this.init(requestParams);){
            DatabaseMetaData metaData = connection.getMetaData();
            String primaryKey = this.getPrimaryKey(metaData, dbName, schemaName, tableName);
            try (ResultSet resultSet = metaData.getColumns(dbName, schemaName, tableName, null);){
                while (resultSet.next()) {
                    TableField tableField = new TableField();
                    String columnName = resultSet.getString("COLUMN_NAME");
                    tableField.setPrimaryKey(Boolean.valueOf(false));
                    if (StringUtils.isNotBlank(primaryKey) && primaryKey.equals(columnName)) {
                        tableField.setPrimaryKey(Boolean.valueOf(true));
                    }
                    tableField.setName(columnName);
                    String typeString = resultSet.getString("TYPE_NAME");
                    String[] parts = typeString.split(" ");
                    String baseType = parts.length > 0 ? parts[0] : "";
                    tableField.setType(baseType);
                    tableField.setComment(resultSet.getString("REMARKS"));
                    Object nullable = resultSet.getObject("IS_NULLABLE");
                    boolean isNullable = this.convertToBoolean(nullable);
                    tableField.setNullable(Boolean.valueOf(isNullable));
                    tableFields.add(tableField);
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourcePluginException("get table fields failed", (Throwable)e);
        }
        return tableFields;
    }

    private String getPrimaryKey(DatabaseMetaData metaData, String dbName, String schemaName, String tableName) throws SQLException {
        try (ResultSet primaryKeysInfo = metaData.getPrimaryKeys(dbName, schemaName, tableName);){
            if (primaryKeysInfo.next()) {
                String string = primaryKeysInfo.getString("COLUMN_NAME");
                return string;
            }
        }
        return null;
    }

    private boolean isNotSystemDatabase(String dbName) {
        return MYSQL_SYSTEM_DATABASES.stream().noneMatch(systemDatabase -> StringUtils.equalsIgnoreCase(systemDatabase, dbName));
    }

    private boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("TRUE");
        }
        return false;
    }

    private Pair<String, String> parseSchemaAndTable(String tableName) {
        String[] schemaAndTable = tableName.split("\\.");
        if (schemaAndTable.length != 2) {
            throw new DataSourcePluginException("table name is invalid");
        }
        return Pair.of(schemaAndTable[0], schemaAndTable[1]);
    }
}

