/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.starrocks;

import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;

public class StarRocksOptionRule {
    public static final Option<List<String>> NODE_URLS = Options.key((String)"nodeUrls").listType().noDefaultValue().withDescription("StarRocks cluster address, the format is [\"fe_ip:fe_http_port\", ...]");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("StarRocks user username");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("StarRocks user password");
    public static final Option<String> DATABASE = Options.key((String)"database").stringType().noDefaultValue().withDescription("The name of StarRocks database");
    public static final Option<String> TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription("The name of StarRocks table");
    public static final Option<String> BASE_URL = Options.key((String)"base-url").stringType().noDefaultValue().withDescription("URL has to be without database, like \"jdbc:mysql://localhost:5432/\" or\"jdbc:mysql://localhost:5432\" rather than \"jdbc:mysql://localhost:5432/db\"");

    public static OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{NODE_URLS, USERNAME, PASSWORD, BASE_URL}).build();
    }

    public static OptionRule metadataRule() {
        return OptionRule.builder().required(new Option[]{DATABASE, TABLE}).build();
    }
}

